/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.security;

import java.util.concurrent.Callable;
import uk.org.webcompere.systemstubs.resource.SingularTestResource;
import uk.org.webcompere.systemstubs.security.AbortExecutionException;

public class SecurityManagerStub<T extends SecurityManager>
extends SingularTestResource {
    private SecurityManager originalSecurityManager;
    private T securityManager;

    public SecurityManagerStub() {
        this(null);
    }

    public SecurityManagerStub(T securityManager) {
        this.securityManager = securityManager;
    }

    public T getSecurityManager() {
        return this.securityManager;
    }

    protected void clearSecurityManager() {
        this.securityManager = null;
    }

    public void setSecurityManager(T securityManager) {
        this.securityManager = securityManager;
        if (this.isActive()) {
            System.setSecurityManager(securityManager);
        }
    }

    @Override
    protected void doSetup() throws Exception {
        this.originalSecurityManager = System.getSecurityManager();
        if (this.securityManager == null) {
            this.securityManager = this.createSecurityManager();
        }
        this.setSecurityManager(this.securityManager);
    }

    @Override
    protected void doTeardown() throws Exception {
        System.setSecurityManager(this.originalSecurityManager);
    }

    protected T createSecurityManager() {
        return null;
    }

    public <R> R execute(Callable<R> callable) throws Exception {
        try {
            return super.execute(callable);
        }
        catch (AbortExecutionException ignoreAbortExecution) {
            return null;
        }
    }
}

