/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import uk.org.webcompere.systemstubs.exception.LoadingException;

public class PropertySource {
    public static Properties fromFile(Path path) {
        return PropertySource.fromFile(path.toFile());
    }

    public static Properties fromFile(String path) {
        return PropertySource.fromFile(Paths.get(path, new String[0]));
    }

    public static Properties fromFile(File file) {
        try {
            return PropertySource.fromInputStream(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new LoadingException("Cannot read file: " + file.getAbsolutePath(), e);
        }
    }

    public static Properties fromResource(String resourceName) {
        return PropertySource.fromInputStream(PropertySource.class.getClassLoader().getResourceAsStream(resourceName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties fromInputStream(InputStream stream) {
        try (InputStream read = stream;){
            Properties properties = new Properties();
            properties.load(read);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new LoadingException("Could not load values", e);
        }
    }
}

