/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.properties;

import java.util.Map;
import java.util.Properties;
import uk.org.webcompere.systemstubs.properties.PropertiesUtils;
import uk.org.webcompere.systemstubs.resource.NameValuePairSetter;
import uk.org.webcompere.systemstubs.resource.SingularTestResource;

public class SystemProperties
extends SingularTestResource
implements NameValuePairSetter<SystemProperties> {
    private Properties originalProperties;
    private Properties properties;

    public SystemProperties() {
        this.properties = new Properties();
    }

    public SystemProperties(Properties properties) {
        this.properties = PropertiesUtils.copyOf(properties);
    }

    public SystemProperties(String name, String value, String ... nameValues) {
        this();
        if (nameValues.length % 2 != 0) {
            throw new IllegalArgumentException("Must have pairs of values");
        }
        this.properties.setProperty(name, value);
        for (int i = 0; i < nameValues.length; i += 2) {
            this.properties.setProperty(nameValues[i], nameValues[i + 1]);
        }
    }

    @Override
    public SystemProperties set(String name, String value) {
        this.properties.setProperty(name, value);
        if (this.isActive()) {
            System.setProperty(name, value);
        }
        return this;
    }

    @Override
    protected void doSetup() throws Exception {
        this.originalProperties = System.getProperties();
        Properties copyProperties = PropertiesUtils.copyOf(this.originalProperties);
        copyProperties.putAll((Map<?, ?>)this.properties);
        System.setProperties(copyProperties);
    }

    @Override
    protected void doTeardown() throws Exception {
        System.setProperties(this.originalProperties);
    }
}

