/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client.async.utils;

import com.ibm.lsid.client.async.utils.KillJob;
import com.ibm.lsid.client.async.utils.ProducerConsumerBuffer;
import com.ibm.lsid.client.async.utils.WorkerThread;
import java.util.Vector;

public class WorkPool {
    private int numthreads = 0;
    private ProducerConsumerBuffer workqueue;
    private static final long CLEANUP_WAIT_TIME = 4000L;
    private int maxthreads;
    private Vector workers = new Vector();

    public synchronized int workerCount() {
        return this.numthreads;
    }

    public WorkPool(int maxthreads) {
        this.maxthreads = maxthreads;
        this.workqueue = new ProducerConsumerBuffer();
    }

    public synchronized void addJob(Runnable job) {
        if (this.numthreads < this.maxthreads && !(job instanceof KillJob)) {
            WorkerThread worker = new WorkerThread(this.workqueue, this);
            this.workers.addElement(worker);
            ++this.numthreads;
            worker.start();
        }
        this.workqueue.put(job);
    }

    public synchronized void destroy() {
        int i = 0;
        while (i < this.numthreads) {
            this.addJob(new KillJob());
            ++i;
        }
        long waittime = 0L;
        while (waittime < 4000L) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            waittime += 1000L;
            if (this.numthreads != 0) continue;
            waittime = 4000L;
        }
        int i2 = 0;
        while (i2 < this.numthreads) {
            WorkerThread worker = (WorkerThread)this.workers.elementAt(i2);
            worker.interrupt();
            ++i2;
        }
    }

    synchronized void removeWorker(WorkerThread worker) {
        if (this.workers.remove(worker)) {
            --this.numthreads;
        }
    }
}

