/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.common;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.core.CoreContainer;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.UnsupportedType;

public class SolrServerFactory {
    public static final String SOLR_HOME_PROPERTY_NAME = "solr.homeDir";
    public static final String SOLR_COLLECTION_NAME_PROPERTY_NAME = "solr.collectionName";
    public static final String SOLR_SERVER_CLASSNAME_PROPERTY_NAME = "solr.server.classname";
    public static final String SOLR_ENPOINT_PROPERTY_NAME = "solr.baseURL";
    private static final String EMBEDDED_SERVER_CLASS = "org.apache.solr.client.solrj.embedded.EmbeddedSolrServer";
    private static final String HTTP_SERVER_CLASS = "org.apache.solr.client.solrj.impl.CommonsHttpSolrServer";
    private static final String CORENAME_PROPERTY_NAME = "solr.coreName";
    private static final String SLASH = "/";
    public static Log log = LogFactory.getLog(SolrServerFactory.class);
    private static CoreContainer coreContainer = null;
    private static String collectionName = null;
    private static SolrClient solrServer = null;
    private static SolrClient solrAdminClient = null;

    public static SolrClient createSolrServer() throws UnsupportedType {
        if (solrServer == null) {
            String className = Settings.getConfiguration().getString(SOLR_SERVER_CLASSNAME_PROPERTY_NAME);
            if (className != null && className.equals(EMBEDDED_SERVER_CLASS)) {
                SolrServerFactory.generateEmbeddedServer();
            } else if (className != null && className.equals(HTTP_SERVER_CLASS)) {
                Object solrServerBaseURL = Settings.getConfiguration().getString(SOLR_ENPOINT_PROPERTY_NAME);
                String coreName = Settings.getConfiguration().getString(CORENAME_PROPERTY_NAME);
                solrServerBaseURL = solrServerBaseURL != null && ((String)solrServerBaseURL).endsWith(SLASH) ? (String)solrServerBaseURL + coreName : (String)solrServerBaseURL + SLASH + coreName;
                log.info((Object)("SolrServerFactory.createSolrServer - the final solr server base url is " + (String)solrServerBaseURL));
                solrServer = new HttpSolrClient.Builder((String)solrServerBaseURL).build();
            } else {
                throw new UnsupportedType("0000", "SolrServerFactory.createSolrServer - MetacatIndex doesn't support this solr server type: " + className);
            }
        }
        return solrServer;
    }

    public static SolrClient createSolrAdminClient() throws UnsupportedType {
        if (solrAdminClient == null) {
            String className = Settings.getConfiguration().getString(SOLR_SERVER_CLASSNAME_PROPERTY_NAME);
            if (className != null && className.equals(EMBEDDED_SERVER_CLASS)) {
                solrAdminClient = null;
            } else if (className != null && className.equals(HTTP_SERVER_CLASS)) {
                String solrServerBaseURL = Settings.getConfiguration().getString(SOLR_ENPOINT_PROPERTY_NAME);
                log.info((Object)("SolrServerFactory.createSolrServer - the final solr server base url is " + solrServerBaseURL));
                solrAdminClient = new HttpSolrClient.Builder(solrServerBaseURL).build();
            } else {
                throw new UnsupportedType("0000", "SolrServerFactory.createSolrServer - MetacatIndex doesn't support this solr server type: " + className);
            }
        }
        return solrAdminClient;
    }

    private static void generateEmbeddedServer() {
        Path path;
        Object solrHomeDir = Settings.getConfiguration().getString(SOLR_HOME_PROPERTY_NAME);
        if (!Paths.get((String)solrHomeDir, new String[0]).isAbsolute()) {
            solrHomeDir = String.valueOf(Paths.get(".", new String[0]).toAbsolutePath().normalize()) + SLASH + (String)solrHomeDir;
        }
        solrHomeDir = (path = Paths.get((String)solrHomeDir, new String[0])).isAbsolute() ? path.normalize().toString() : Paths.get("", new String[0]).resolve((String)solrHomeDir).normalize().toString();
        log.info((Object)("The configured solr home from properties is " + (String)solrHomeDir));
        Properties properties = new Properties();
        coreContainer = new CoreContainer(Paths.get((String)solrHomeDir, new String[0]), properties);
        coreContainer.load();
        collectionName = SolrServerFactory.getCollectionName();
        solrServer = new EmbeddedSolrServer(coreContainer, collectionName);
    }

    public static CoreContainer getCoreContainer() throws UnsupportedType {
        if (coreContainer == null) {
            SolrServerFactory.createSolrServer();
        }
        return coreContainer;
    }

    public static String getCollectionName() {
        if (collectionName == null) {
            collectionName = Settings.getConfiguration().getString(SOLR_COLLECTION_NAME_PROPERTY_NAME);
        }
        return collectionName;
    }
}

