/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.hashstore.hashstoreconverter;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.hashstore.ObjectMetadata;
import org.dataone.hashstore.exceptions.NonMatchingChecksumException;
import org.dataone.hashstore.filehashstore.FileHashStore;
import org.dataone.hashstore.filehashstore.FileHashStoreUtility;

public class FileHashStoreLinks
extends FileHashStore {
    private static final Log logFileHashStoreLinks = LogFactory.getLog(FileHashStore.class);
    private final int DIRECTORY_DEPTH;
    private final int DIRECTORY_WIDTH;
    private final String OBJECT_STORE_ALGORITHM;
    private final Path OBJECT_STORE_DIRECTORY;

    public FileHashStoreLinks(Properties hashstoreProperties) throws IllegalArgumentException, IOException, NoSuchAlgorithmException {
        super(hashstoreProperties);
        Path storePath = Paths.get(hashstoreProperties.getProperty(FileHashStore.HashStoreProperties.storePath.name()), new String[0]);
        int storeDepth = Integer.parseInt(hashstoreProperties.getProperty(FileHashStore.HashStoreProperties.storeDepth.name()));
        int storeWidth = Integer.parseInt(hashstoreProperties.getProperty(FileHashStore.HashStoreProperties.storeWidth.name()));
        String storeAlgorithm = hashstoreProperties.getProperty(FileHashStore.HashStoreProperties.storeAlgorithm.name());
        this.DIRECTORY_DEPTH = storeDepth;
        this.DIRECTORY_WIDTH = storeWidth;
        this.OBJECT_STORE_ALGORITHM = storeAlgorithm;
        this.OBJECT_STORE_DIRECTORY = storePath.resolve("objects");
        logFileHashStoreLinks.info((Object)"FileHashStoreLinks initialized");
    }

    public ObjectMetadata storeHardLink(Path filePath, String pid, String checksum, String checksumAlgorithm) throws NoSuchAlgorithmException, IOException, InterruptedException {
        FileHashStoreUtility.ensureNotNull(filePath, "filePath");
        FileHashStoreUtility.ensureNotNull(pid, "pid");
        FileHashStoreUtility.checkForNotEmptyAndValidString(pid, "pid");
        FileHashStoreUtility.ensureNotNull(checksum, "checksum");
        FileHashStoreUtility.checkForNotEmptyAndValidString(checksum, "checksum");
        this.validateAlgorithm(checksumAlgorithm);
        if (!Files.exists(filePath, new LinkOption[0])) {
            String errMsg = "Given file path: " + filePath + " does not exist.";
            throw new FileNotFoundException(errMsg);
        }
        try (InputStream fileStream = Files.newInputStream(filePath, new OpenOption[0]);){
            Map<String, String> hexDigests = this.generateChecksums(fileStream, checksumAlgorithm);
            FileHashStoreUtility.ensureNotNull(hexDigests, "hexDigests");
            String checksumToMatch = hexDigests.get(checksumAlgorithm);
            if (!checksum.equalsIgnoreCase(checksumToMatch)) {
                String errMsg = "Checksum supplied: " + checksum + " does not match what has been calculated: " + checksumToMatch + " for pid: " + pid + " and checksum algorithm: " + checksumAlgorithm;
                logFileHashStoreLinks.error((Object)errMsg);
                throw new NonMatchingChecksumException(errMsg, hexDigests);
            }
            String objectCid = hexDigests.get(this.OBJECT_STORE_ALGORITHM);
            String objRelativePath = FileHashStoreUtility.getHierarchicalPathString(this.DIRECTORY_DEPTH, this.DIRECTORY_WIDTH, objectCid);
            Path objHardLinkPath = this.OBJECT_STORE_DIRECTORY.resolve(objRelativePath);
            FileHashStoreUtility.createParentDirectories(objHardLinkPath);
            try {
                Files.createLink(objHardLinkPath, filePath);
            }
            catch (FileAlreadyExistsException faee) {
                logFileHashStoreLinks.debug((Object)("Data object already exists at: " + objHardLinkPath));
            }
            this.tagObject(pid, objectCid);
            logFileHashStoreLinks.info((Object)("Hard link has been created for pid:" + pid + " with cid: " + objectCid + ", and has been tagged"));
            ObjectMetadata objectMetadata = new ObjectMetadata(pid, objectCid, Files.size(objHardLinkPath), hexDigests);
            return objectMetadata;
        }
    }

    protected Path getHashStoreLinksDataObjectPath(String pid) throws NoSuchAlgorithmException, IOException {
        return this.getHashStoreDataObjectPath(pid);
    }

    protected Map<String, String> generateChecksums(InputStream dataStream, String additionalAlgorithm) throws NoSuchAlgorithmException, IOException, SecurityException {
        boolean generateAddAlgo = false;
        if (additionalAlgorithm != null) {
            this.validateAlgorithm(additionalAlgorithm);
            generateAddAlgo = this.shouldCalculateAlgorithm(additionalAlgorithm);
        }
        MessageDigest md5 = MessageDigest.getInstance(FileHashStore.DefaultHashAlgorithms.MD5.getName());
        MessageDigest sha1 = MessageDigest.getInstance(FileHashStore.DefaultHashAlgorithms.SHA_1.getName());
        MessageDigest sha256 = MessageDigest.getInstance(FileHashStore.DefaultHashAlgorithms.SHA_256.getName());
        MessageDigest sha384 = MessageDigest.getInstance(FileHashStore.DefaultHashAlgorithms.SHA_384.getName());
        MessageDigest sha512 = MessageDigest.getInstance(FileHashStore.DefaultHashAlgorithms.SHA_512.getName());
        MessageDigest additionalAlgo = null;
        if (generateAddAlgo) {
            logFileHashStoreLinks.debug((Object)("Adding additional algorithm to hex digest map, algorithm: " + additionalAlgorithm));
            additionalAlgo = MessageDigest.getInstance(additionalAlgorithm);
        }
        try (InputStream inputStream = dataStream;){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = dataStream.read(buffer)) != -1) {
                md5.update(buffer, 0, bytesRead);
                sha1.update(buffer, 0, bytesRead);
                sha256.update(buffer, 0, bytesRead);
                sha384.update(buffer, 0, bytesRead);
                sha512.update(buffer, 0, bytesRead);
                if (!generateAddAlgo) continue;
                additionalAlgo.update(buffer, 0, bytesRead);
            }
        }
        catch (IOException ioe) {
            String errMsg = "Unexpected Exception ~ " + ioe.getMessage();
            logFileHashStoreLinks.error((Object)errMsg);
            throw ioe;
        }
        HashMap<String, String> hexDigests = new HashMap<String, String>();
        String md5Digest = DatatypeConverter.printHexBinary((byte[])md5.digest()).toLowerCase();
        String sha1Digest = DatatypeConverter.printHexBinary((byte[])sha1.digest()).toLowerCase();
        String sha256Digest = DatatypeConverter.printHexBinary((byte[])sha256.digest()).toLowerCase();
        String sha384Digest = DatatypeConverter.printHexBinary((byte[])sha384.digest()).toLowerCase();
        String sha512Digest = DatatypeConverter.printHexBinary((byte[])sha512.digest()).toLowerCase();
        hexDigests.put(FileHashStore.DefaultHashAlgorithms.MD5.getName(), md5Digest);
        hexDigests.put(FileHashStore.DefaultHashAlgorithms.SHA_1.getName(), sha1Digest);
        hexDigests.put(FileHashStore.DefaultHashAlgorithms.SHA_256.getName(), sha256Digest);
        hexDigests.put(FileHashStore.DefaultHashAlgorithms.SHA_384.getName(), sha384Digest);
        hexDigests.put(FileHashStore.DefaultHashAlgorithms.SHA_512.getName(), sha512Digest);
        if (generateAddAlgo) {
            String extraAlgoDigest = DatatypeConverter.printHexBinary((byte[])additionalAlgo.digest()).toLowerCase();
            hexDigests.put(additionalAlgorithm, extraAlgoDigest);
        }
        logFileHashStoreLinks.debug((Object)"Checksums have been calculated.");
        return hexDigests;
    }
}

