/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.hashstore;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import org.dataone.hashstore.ObjectMetadata;
import org.dataone.hashstore.exceptions.NonMatchingChecksumException;
import org.dataone.hashstore.exceptions.NonMatchingObjSizeException;
import org.dataone.hashstore.exceptions.PidRefsFileExistsException;
import org.dataone.hashstore.exceptions.UnsupportedHashAlgorithmException;

public interface HashStore {
    public ObjectMetadata storeObject(InputStream var1, String var2, String var3, String var4, String var5, long var6) throws NoSuchAlgorithmException, IOException, PidRefsFileExistsException, RuntimeException, InterruptedException;

    public ObjectMetadata storeObject(InputStream var1) throws NoSuchAlgorithmException, IOException, RuntimeException, InterruptedException;

    public void tagObject(String var1, String var2) throws IOException, PidRefsFileExistsException, NoSuchAlgorithmException, FileNotFoundException, InterruptedException;

    public void deleteIfInvalidObject(ObjectMetadata var1, String var2, String var3, long var4) throws NonMatchingObjSizeException, NonMatchingChecksumException, UnsupportedHashAlgorithmException, InterruptedException, NoSuchAlgorithmException, IOException;

    public String storeMetadata(InputStream var1, String var2, String var3) throws IOException, IllegalArgumentException, FileNotFoundException, InterruptedException, NoSuchAlgorithmException;

    public String storeMetadata(InputStream var1, String var2) throws IOException, IllegalArgumentException, InterruptedException, NoSuchAlgorithmException;

    public InputStream retrieveObject(String var1) throws IllegalArgumentException, FileNotFoundException, IOException, NoSuchAlgorithmException;

    public InputStream retrieveMetadata(String var1, String var2) throws IllegalArgumentException, FileNotFoundException, IOException, NoSuchAlgorithmException;

    public InputStream retrieveMetadata(String var1) throws IllegalArgumentException, IOException, NoSuchAlgorithmException;

    public void deleteObject(String var1) throws IllegalArgumentException, IOException, NoSuchAlgorithmException, InterruptedException;

    public void deleteMetadata(String var1, String var2) throws IllegalArgumentException, IOException, NoSuchAlgorithmException, InterruptedException;

    public void deleteMetadata(String var1) throws IllegalArgumentException, IOException, NoSuchAlgorithmException, InterruptedException;

    public String getHexDigest(String var1, String var2) throws IllegalArgumentException, FileNotFoundException, IOException, NoSuchAlgorithmException;
}

