/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils;

import java.util.Enumeration;

public class MyStringTokenizer
implements Enumeration {
    private char[] string;
    private String delim;
    private boolean returnTokens;
    private int current;
    private String putBack;

    public MyStringTokenizer(String s, String delim, boolean returnTokens) {
        this.string = new char[s.length()];
        s.getChars(0, s.length(), this.string, 0);
        this.delim = delim;
        this.returnTokens = returnTokens;
        this.current = 0;
    }

    public MyStringTokenizer(String s, String delim) {
        this(s, delim, false);
    }

    public MyStringTokenizer(String s) {
        this(s, " \t\n\r", false);
    }

    private boolean isDelim(int i) {
        return this.delim.indexOf(this.string[i]) >= 0;
    }

    public boolean hasMoreTokens() {
        if (this.putBack != null) {
            return true;
        }
        if (this.current >= this.string.length) {
            return false;
        }
        if (!this.isDelim(this.current) || this.returnTokens) {
            return true;
        }
        int t = this.current;
        while (t < this.string.length && this.isDelim(t)) {
            ++t;
        }
        return t < this.string.length;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public boolean hasMoreDelimiters() {
        return this.current < this.string.length;
    }

    public String nextToken() {
        if (this.putBack != null) {
            String s = this.putBack;
            this.putBack = null;
            return s;
        }
        int start = this.current;
        if (this.current >= this.string.length) {
            return null;
        }
        if (this.isDelim(this.current)) {
            while (this.current < this.string.length && this.isDelim(this.current)) {
                ++this.current;
            }
            if (this.returnTokens) {
                return new String(this.string, start, this.current - start);
            }
            if (this.current >= this.string.length) {
                return null;
            }
        }
        boolean quoted = false;
        boolean escaped = false;
        StringBuffer sb = new StringBuffer();
        while (this.current != this.string.length) {
            if (escaped) {
                sb.append('\\');
                sb.append(this.string[this.current]);
                escaped = false;
            } else if (quoted) {
                if (this.string[this.current] == '\"') {
                    ++this.current;
                    break;
                }
                sb.append(this.string[this.current]);
            } else if (this.string[this.current] == '\"') {
                quoted = true;
            } else if (this.string[this.current] == '\\') {
                escaped = true;
            } else {
                if (this.isDelim(this.current)) break;
                sb.append(this.string[this.current]);
            }
            ++this.current;
        }
        return sb.toString();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public void putBackToken(String s) {
        this.putBack = s;
    }

    public String remainingTokens() {
        StringBuffer sb = new StringBuffer();
        while (this.hasMoreTokens()) {
            sb.append(this.nextToken());
        }
        return sb.toString();
    }
}

