/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;

public class DataByteInputStream
extends ByteArrayInputStream {
    public DataByteInputStream(byte[] b) {
        super(b);
    }

    public int read(byte[] b) throws IOException {
        int n = this.read(b, 0, b.length);
        if (n < b.length) {
            throw new IOException("end of input");
        }
        return n;
    }

    public int readArray(byte[] b, int pos, int len) throws IOException {
        int n = this.read(b, pos, len);
        if (n < len) {
            throw new IOException("end of input");
        }
        return n;
    }

    public byte readByte() throws IOException {
        int i = this.read();
        if (i == -1) {
            throw new IOException("end of input");
        }
        return (byte)i;
    }

    public int readUnsignedByte() throws IOException {
        int i = this.read();
        if (i == -1) {
            throw new IOException("end of input");
        }
        return i;
    }

    public short readShort() throws IOException {
        int c1 = this.read();
        int c2 = this.read();
        if (c1 == -1 || c2 == -1) {
            throw new IOException("end of input");
        }
        return (short)((c1 << 8) + c2);
    }

    public int readUnsignedShort() throws IOException {
        int c1 = this.read();
        int c2 = this.read();
        if (c1 == -1 || c2 == -1) {
            throw new IOException("end of input");
        }
        return (c1 << 8) + c2;
    }

    public int readInt() throws IOException {
        int c1 = this.read();
        int c2 = this.read();
        int c3 = this.read();
        int c4 = this.read();
        if (c1 == -1 || c2 == -1 || c3 == -1 || c4 == -1) {
            throw new IOException("end of input");
        }
        return (c1 << 24) + (c2 << 16) + (c3 << 8) + c4;
    }

    public long readLong() throws IOException {
        int c1 = this.read();
        int c2 = this.read();
        int c3 = this.read();
        int c4 = this.read();
        int c5 = this.read();
        int c6 = this.read();
        int c7 = this.read();
        int c8 = this.read();
        if (c1 == -1 || c2 == -1 || c3 == -1 || c4 == -1 || c5 == -1 || c6 == -1 || c7 == -1 || c8 == -1) {
            throw new IOException("end of input");
        }
        return (c1 << 56) + (c2 << 48) + (c3 << 40) + (c4 << 32) + (c5 << 24) + (c6 << 16) + (c7 << 8) + c8;
    }

    public String readString() throws IOException {
        int len = this.read();
        if (len == -1) {
            throw new IOException("end of input");
        }
        byte[] b = new byte[len];
        int n = this.read(b);
        if (n < len) {
            throw new IOException("end of input");
        }
        return new String(b);
    }

    public BigInteger readBigInteger(int len) throws IOException {
        byte[] b = new byte[len + 1];
        int n = this.read(b, 1, len);
        if (n < len) {
            throw new IOException("end of input");
        }
        return new BigInteger(b);
    }

    public void skipBytes(int n) throws IOException {
        this.skip(n);
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }
}

