/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.security;

import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.interfaces.DHPublicKey;
import org.xbill.DNS.KEYRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.security.DHPubKey;
import org.xbill.DNS.security.DSAPubKey;
import org.xbill.DNS.security.RSAPubKey;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;

public class KEYConverter {
    private static final BigInteger DHPRIME768 = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A63A3620FFFFFFFFFFFFFFFF", 16);
    private static final BigInteger DHPRIME1024 = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE65381FFFFFFFFFFFFFFFF", 16);
    private static final BigInteger TWO = new BigInteger("2", 16);

    static int BigIntegerLength(BigInteger i) {
        byte[] b = i.toByteArray();
        return b[0] == 0 ? b.length - 1 : b.length;
    }

    static RSAPublicKey parseRSA(DataByteInputStream in) throws IOException {
        int exponentLength = in.readUnsignedByte();
        if (exponentLength == 0) {
            exponentLength = in.readUnsignedShort();
        }
        BigInteger exponent = in.readBigInteger(exponentLength);
        int modulusLength = in.available();
        BigInteger modulus = in.readBigInteger(modulusLength);
        RSAPubKey rsa = new RSAPubKey(modulus, exponent);
        return rsa;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static DHPublicKey parseDH(DataByteInputStream in) throws IOException {
        BigInteger g;
        BigInteger p;
        int special = 0;
        int pLength = in.readUnsignedShort();
        if (pLength < 16 && pLength != 1 && pLength != 2) {
            return null;
        }
        if (pLength == 1 || pLength == 2) {
            special = pLength == 1 ? in.readUnsignedByte() : in.readUnsignedShort();
            if (special != 1 && special != 2) {
                return null;
            }
            p = special == 1 ? DHPRIME768 : DHPRIME1024;
        } else {
            p = in.readBigInteger(pLength);
        }
        int gLength = in.readUnsignedShort();
        if (gLength == 0) {
            if (special == 0) return null;
            g = TWO;
        } else {
            g = in.readBigInteger(gLength);
        }
        int yLength = in.readUnsignedShort();
        BigInteger y = in.readBigInteger(yLength);
        return new DHPubKey(p, g, y);
    }

    static DSAPublicKey parseDSA(DataByteInputStream in) throws IOException {
        byte t = in.readByte();
        BigInteger q = in.readBigInteger(20);
        BigInteger p = in.readBigInteger(64 + t * 8);
        BigInteger g = in.readBigInteger(64 + t * 8);
        BigInteger y = in.readBigInteger(64 + t * 8);
        DSAPubKey dsa = new DSAPubKey(p, q, g, y);
        return dsa;
    }

    public static PublicKey parseRecord(KEYRecord r) {
        byte alg = r.getAlgorithm();
        byte[] data = r.getKey();
        DataByteInputStream dbs = new DataByteInputStream(data);
        try {
            switch (alg) {
                case 1: 
                case 5: {
                    return KEYConverter.parseRSA(dbs);
                }
                case 2: {
                    return KEYConverter.parseDH(dbs);
                }
                case 3: {
                    return KEYConverter.parseDSA(dbs);
                }
            }
            return null;
        }
        catch (IOException e) {
            if (Options.check("verboseexceptions")) {
                System.err.println(e);
            }
            return null;
        }
    }

    static byte[] buildRSA(RSAPublicKey key) {
        DataByteOutputStream out = new DataByteOutputStream();
        BigInteger exponent = key.getPublicExponent();
        BigInteger modulus = key.getModulus();
        int exponentLength = KEYConverter.BigIntegerLength(exponent);
        if (exponentLength < 256) {
            out.writeByte(exponentLength);
        } else {
            out.writeByte(0);
            out.writeShort(exponentLength);
        }
        out.writeBigInteger(exponent);
        out.writeBigInteger(modulus);
        return out.toByteArray();
    }

    static byte[] buildDH(DHPublicKey key) {
        int gLength;
        int pLength;
        DataByteOutputStream out = new DataByteOutputStream();
        BigInteger p = key.getParams().getP();
        BigInteger g = key.getParams().getG();
        BigInteger y = key.getY();
        if (g.equals(TWO) && (p.equals(DHPRIME768) || p.equals(DHPRIME1024))) {
            pLength = 1;
            gLength = 0;
        } else {
            pLength = KEYConverter.BigIntegerLength(p);
            gLength = KEYConverter.BigIntegerLength(g);
        }
        int yLength = KEYConverter.BigIntegerLength(y);
        out.writeShort(pLength);
        if (pLength == 1) {
            if (p.bitLength() == 768) {
                out.writeByte(1);
            } else {
                out.writeByte(2);
            }
        } else {
            out.writeBigInteger(p);
        }
        out.writeShort(gLength);
        if (gLength > 0) {
            out.writeBigInteger(g);
        }
        out.writeShort(yLength);
        out.writeBigInteger(y);
        return out.toByteArray();
    }

    static byte[] buildDSA(DSAPublicKey key) {
        DataByteOutputStream out = new DataByteOutputStream();
        BigInteger q = key.getParams().getQ();
        BigInteger p = key.getParams().getP();
        BigInteger g = key.getParams().getG();
        BigInteger y = key.getY();
        int t = (p.toByteArray().length - 64) / 8;
        out.writeByte(t);
        out.writeBigInteger(q);
        out.writeBigInteger(p);
        out.writeBigInteger(g);
        out.writeBigInteger(y);
        return out.toByteArray();
    }

    public static KEYRecord buildRecord(Name name, short dclass, int ttl, int flags, int proto, PublicKey key) {
        byte[] data;
        int alg;
        if (key instanceof RSAPublicKey) {
            alg = 1;
            data = KEYConverter.buildRSA((RSAPublicKey)key);
        } else if (key instanceof DHPublicKey) {
            alg = 2;
            data = KEYConverter.buildDH((DHPublicKey)key);
        } else if (key instanceof DSAPublicKey) {
            alg = 3;
            data = KEYConverter.buildDSA((DSAPublicKey)key);
        } else {
            return null;
        }
        if (data == null) {
            return null;
        }
        return new KEYRecord(name, dclass, ttl, flags, proto, alg, data);
    }
}

