/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.SIGRecord;
import org.xbill.DNS.TTL;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;
import org.xbill.DNS.UNKRecord;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;
import org.xbill.DNS.utils.base16;

public abstract class Record
implements Cloneable,
Comparable {
    protected Name name;
    protected short type;
    protected short dclass;
    protected int ttl;
    private static final Record[] knownRecords = new Record[256];
    private static final Class[] emptyClassArray = new Class[0];
    private static final Object[] emptyObjectArray = new Object[0];
    static /* synthetic */ Class class$org$xbill$DNS$Record;

    protected Record() {
    }

    Record(Name name, short type, short dclass, int ttl) {
        this.name = name;
        this.type = type;
        this.dclass = dclass;
        this.ttl = ttl;
    }

    private static final Record getTypedObject(short type) {
        block10: {
            if (type < 0 || type > knownRecords.length) {
                return UNKRecord.getMember();
            }
            if (knownRecords[type] != null) {
                return knownRecords[type];
            }
            try {
                String s = (class$org$xbill$DNS$Record == null ? (class$org$xbill$DNS$Record = Record.class$("org.xbill.DNS.Record")) : class$org$xbill$DNS$Record).getName();
                Class<?> c = Class.forName(s.substring(0, s.length() - 6) + Type.string(type) + "Record");
                Method m = c.getDeclaredMethod("getMember", emptyClassArray);
                Record.knownRecords[type] = (Record)m.invoke(null, emptyObjectArray);
            }
            catch (ClassNotFoundException e) {
            }
            catch (InvocationTargetException e) {
                if (Options.check("verbose")) {
                    System.err.println(e);
                }
            }
            catch (NoSuchMethodException e) {
                if (Options.check("verbose")) {
                    System.err.println(e);
                }
            }
            catch (IllegalAccessException e) {
                if (!Options.check("verbose")) break block10;
                System.err.println(e);
            }
        }
        if (knownRecords[type] == null) {
            Record.knownRecords[type] = UNKRecord.getMember();
        }
        return knownRecords[type];
    }

    abstract Record rrFromWire(Name var1, short var2, short var3, int var4, int var5, DataByteInputStream var6) throws IOException;

    private static Record newRecord(Name name, short type, short dclass, int ttl, int length, DataByteInputStream in) throws IOException {
        int recstart = in == null ? 0 : in.getPos();
        Record rec = Record.getTypedObject(type);
        rec = rec.rrFromWire(name, type, dclass, ttl, length, in);
        if (in != null && in.getPos() - recstart != length) {
            throw new IOException("Invalid record length");
        }
        return rec;
    }

    public static Record newRecord(Name name, short type, short dclass, int ttl, int length, byte[] data) {
        DataByteInputStream dbs = data != null ? new DataByteInputStream(data) : null;
        try {
            return Record.newRecord(name, type, dclass, ttl, length, dbs);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Record newRecord(Name name, short type, short dclass, int ttl, byte[] data) {
        return Record.newRecord(name, type, dclass, ttl, data.length, data);
    }

    public static Record newRecord(Name name, short type, short dclass, int ttl) {
        return Record.newRecord(name, type, dclass, ttl, 0, (byte[])null);
    }

    public static Record newRecord(Name name, short type, short dclass) {
        return Record.newRecord(name, type, dclass, 0, 0, (byte[])null);
    }

    static Record fromWire(DataByteInputStream in, int section) throws IOException {
        int start = in.getPos();
        Name name = new Name(in);
        short type = in.readShort();
        short dclass = in.readShort();
        if (section == 0) {
            return Record.newRecord(name, type, dclass);
        }
        int ttl = in.readInt();
        short length = in.readShort();
        if (length == 0) {
            return Record.newRecord(name, type, dclass, ttl);
        }
        Record rec = Record.newRecord(name, type, dclass, ttl, (int)length, in);
        return rec;
    }

    public static Record fromWire(byte[] b, int section) throws IOException {
        DataByteInputStream in = new DataByteInputStream(b);
        return Record.fromWire(in, section);
    }

    void toWire(DataByteOutputStream out, int section, Compression c) {
        int start = out.getPos();
        this.name.toWire(out, c);
        out.writeShort(this.type);
        out.writeShort(this.dclass);
        if (section == 0) {
            return;
        }
        out.writeInt(this.ttl);
        int lengthPosition = out.getPos();
        out.writeShort(0);
        this.rrToWire(out, c, false);
        out.writeShortAt(out.getPos() - lengthPosition - 2, lengthPosition);
    }

    public byte[] toWire(int section) {
        DataByteOutputStream out = new DataByteOutputStream();
        this.toWire(out, section, null);
        return out.toByteArray();
    }

    void toWireCanonical(DataByteOutputStream out) {
        this.name.toWireCanonical(out);
        out.writeShort(this.type);
        out.writeShort(this.dclass);
        out.writeInt(this.ttl);
        int lengthPosition = out.getPos();
        out.writeShort(0);
        this.rrToWire(out, null, true);
        out.writeShortAt(out.getPos() - lengthPosition - 2, lengthPosition);
    }

    public byte[] toWireCanonical() {
        DataByteOutputStream out = new DataByteOutputStream();
        this.toWireCanonical(out);
        return out.toByteArray();
    }

    public byte[] rdataToWireCanonical() throws IOException {
        DataByteOutputStream out = new DataByteOutputStream();
        this.rrToWire(out, null, true);
        return out.toByteArray();
    }

    public abstract String rdataToString();

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append("\t");
        if (Options.check("BINDTTL")) {
            sb.append(TTL.format(this.ttl));
        } else {
            sb.append((long)this.ttl & 0xFFFFFFFFL);
        }
        sb.append(" ");
        if (this.dclass != 1 || !Options.check("noPrintIN")) {
            sb.append(DClass.string(this.dclass));
            sb.append(" ");
        }
        sb.append(Type.string(this.type));
        sb.append("\t\t");
        sb.append(this.rdataToString());
        return sb.toString();
    }

    abstract Record rdataFromString(Name var1, short var2, int var3, MyStringTokenizer var4, Name var5) throws TextParseException;

    public static Record fromString(Name name, short type, short dclass, int ttl, MyStringTokenizer st, Name origin) throws IOException {
        Record rec;
        String s = st.nextToken();
        if (s.equals("#")) {
            byte[] data;
            s = st.nextToken();
            short length = Short.parseShort(s);
            if (length != (data = base16.fromString(s = st.remainingTokens())).length) {
                throw new IOException("Invalid unknown RR encoding: length mismatch");
            }
            DataByteInputStream in = new DataByteInputStream(data);
            rec = Record.newRecord(name, type, dclass, ttl, (int)length, in);
        }
        st.putBackToken(s);
        rec = Record.getTypedObject(type);
        return rec.rdataFromString(name, dclass, ttl, st, origin);
    }

    public static Record fromString(Name name, short type, short dclass, int ttl, String s, Name origin) throws IOException {
        return Record.fromString(name, type, dclass, ttl, new MyStringTokenizer(s), origin);
    }

    public Name getName() {
        return this.name;
    }

    public short getType() {
        return this.type;
    }

    public short getRRsetType() {
        if (this.type == 24) {
            SIGRecord sig = (SIGRecord)this;
            return sig.getTypeCovered();
        }
        return this.type;
    }

    public short getDClass() {
        return this.dclass;
    }

    public int getTTL() {
        return this.ttl;
    }

    abstract void rrToWire(DataByteOutputStream var1, Compression var2, boolean var3);

    public boolean equals(Object arg) {
        if (arg == null || !(arg instanceof Record)) {
            return false;
        }
        Record r = (Record)arg;
        try {
            if (this.type != r.type || this.dclass != r.dclass || !this.name.equals(r.name)) {
                return false;
            }
            byte[] array1 = this.rdataToWireCanonical();
            byte[] array2 = r.rdataToWireCanonical();
            return Arrays.equals(array1, array2);
        }
        catch (IOException e) {
            return false;
        }
    }

    public int hashCode() {
        byte[] array = this.toWireCanonical();
        return array.hashCode();
    }

    public Record withName(Name name) {
        Record rec = null;
        try {
            rec = (Record)this.clone();
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        rec.name = name;
        return rec;
    }

    public int compareTo(Object o) {
        Record arg = (Record)o;
        if (this == arg) {
            return 0;
        }
        int n = this.name.compareTo(arg.name);
        if (n != 0) {
            return n;
        }
        n = this.dclass - arg.dclass;
        if (n != 0) {
            return n;
        }
        n = this.type - arg.type;
        if (n != 0) {
            return n;
        }
        byte[] rdata1 = this.toWireCanonical();
        byte[] rdata2 = arg.toWireCanonical();
        int i = 0;
        while (i < rdata1.length && i < rdata2.length) {
            n = (rdata1[i] & 0xFF) - (rdata2[i] & 0xFF);
            if (n != 0) {
                return n;
            }
            ++i;
        }
        return rdata1.length - rdata2.length;
    }

    public Name getAdditionalName() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

