/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class EagerACLFilterTest
extends QuorumBase {
    protected boolean complete = false;
    protected static final String PARENT_PATH = "/foo";
    protected static final String CHILD_PATH = "/foo/bar";
    protected static final String AUTH_PROVIDER = "digest";
    protected static final byte[] AUTH = "hello".getBytes();
    protected static final byte[] AUTHB = "goodbye".getBytes();
    protected static final byte[] DATA = "Hint Water".getBytes();
    protected TestableZooKeeper zkClient;
    protected TestableZooKeeper zkClientB;
    protected TestableZooKeeper zkLeaderClient;
    protected QuorumPeer zkLeader;
    protected QuorumPeer zkConnected;
    protected ZooKeeperServer connectedServer;

    public static Stream<Arguments> data() {
        return Stream.of(Arguments.of((Object[])new Object[]{QuorumPeer.ServerState.LEADING, true}), Arguments.of((Object[])new Object[]{QuorumPeer.ServerState.LEADING, false}), Arguments.of((Object[])new Object[]{QuorumPeer.ServerState.FOLLOWING, true}), Arguments.of((Object[])new Object[]{QuorumPeer.ServerState.FOLLOWING, false}), Arguments.of((Object[])new Object[]{QuorumPeer.ServerState.OBSERVING, true}), Arguments.of((Object[])new Object[]{QuorumPeer.ServerState.OBSERVING, false}));
    }

    @Override
    @BeforeEach
    public void setUp() {
    }

    public void setUp(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.ensureCheck(checkEnabled);
        ClientBase.CountdownWatcher leaderWatch = new ClientBase.CountdownWatcher();
        ClientBase.CountdownWatcher clientWatch = new ClientBase.CountdownWatcher();
        ClientBase.CountdownWatcher clientWatchB = new ClientBase.CountdownWatcher();
        super.setUp(true, true);
        String hostPort = this.getPeersMatching(serverState).split(",")[0];
        int clientPort = Integer.parseInt(hostPort.split(":")[1]);
        this.zkLeader = this.getPeerList().get(this.getLeaderIndex());
        this.zkConnected = this.getPeerByClientPort(clientPort);
        this.connectedServer = this.zkConnected.getActiveServer();
        this.zkLeaderClient = this.createClient(leaderWatch, this.getPeersMatching(QuorumPeer.ServerState.LEADING));
        this.zkClient = this.createClient(clientWatch, hostPort);
        this.zkClientB = this.createClient(clientWatchB, hostPort);
        this.zkClient.addAuthInfo(AUTH_PROVIDER, AUTH);
        this.zkClientB.addAuthInfo(AUTH_PROVIDER, AUTHB);
        leaderWatch.waitForConnected(CONNECTION_TIMEOUT);
        clientWatch.waitForConnected(CONNECTION_TIMEOUT);
        clientWatchB.waitForConnected(CONNECTION_TIMEOUT);
    }

    void syncClient(ZooKeeper zk) {
        CompletableFuture synced = new CompletableFuture();
        zk.sync("/", (rc, path, ctx) -> {
            if (rc == 0) {
                synced.complete(null);
            } else {
                synced.completeExceptionally(KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc)));
            }
        }, null);
        synced.join();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        if (this.zkClient != null) {
            this.zkClient.close();
        }
        if (this.zkClientB != null) {
            this.zkClientB.close();
        }
        super.tearDown();
    }

    private void ensureCheck(boolean enabled) {
        ZooKeeperServer.setEnableEagerACLCheck((boolean)enabled);
    }

    private void assertTransactionState(String operation, QuorumPeer peer, long lastxid) {
        if (peer == this.zkLeader && peer != this.zkConnected) {
            this.syncClient((ZooKeeper)this.zkLeaderClient);
        }
        Assertions.assertTrue((peer == this.zkLeader || peer == this.zkConnected ? 1 : 0) != 0);
        boolean eagerACL = ZooKeeperServer.isEnableEagerACLCheck();
        String assertion = String.format("Connecting: %s Checking: %s EagerACL: %s Operation: %s", this.zkConnected.getPeerState(), peer.getPeerState(), eagerACL, operation);
        if (eagerACL) {
            Assertions.assertEquals((long)lastxid, (long)peer.getLastLoggedZxid(), (String)assertion);
        } else {
            Assertions.assertNotEquals((long)lastxid, (long)peer.getLastLoggedZxid(), (String)assertion);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testCreateOK(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.setUp(serverState, checkEnabled);
        this.ensureCheck(true);
        this.zkClient.create(PARENT_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zkClientB.create(CHILD_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assertions.assertEquals((int)0, (int)this.connectedServer.getInProcess(), (String)"OutstandingRequests not decremented");
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testCreate2OK(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.setUp(serverState, checkEnabled);
        this.zkClient.create(PARENT_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, null);
        this.zkClientB.create(CHILD_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, null);
        Assertions.assertEquals((int)0, (int)this.connectedServer.getInProcess(), (String)"OutstandingRequests not decremented");
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testCreateFail(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.setUp(serverState, checkEnabled);
        this.zkClient.create(PARENT_PATH, DATA, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
        long lastxid = this.zkConnected.getLastLoggedZxid();
        try {
            this.zkClientB.create(CHILD_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assertions.fail((String)"expect no auth");
        }
        catch (KeeperException.NoAuthException noAuthException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.connectedServer.getInProcess(), (String)"OutstandingRequests not decremented");
        this.assertTransactionState("failed create", this.zkConnected, lastxid);
        this.assertTransactionState("failed create", this.zkLeader, lastxid);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testCreate2Fail(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.setUp(serverState, checkEnabled);
        this.zkClient.create(PARENT_PATH, DATA, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT, null);
        long lastxid = this.zkConnected.getLastLoggedZxid();
        try {
            this.zkClientB.create(CHILD_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, null);
            Assertions.fail((String)"expect no auth");
        }
        catch (KeeperException.NoAuthException noAuthException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.connectedServer.getInProcess(), (String)"OutstandingRequests not decremented");
        this.assertTransactionState("failed create2", this.zkConnected, lastxid);
        this.assertTransactionState("failed create2", this.zkLeader, lastxid);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testDeleteOK(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.setUp(serverState, checkEnabled);
        this.zkClient.create(PARENT_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zkClientB.delete(PARENT_PATH, -1);
        Assertions.assertEquals((int)0, (int)this.connectedServer.getInProcess(), (String)"OutstandingRequests not decremented");
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testDeleteFail(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.setUp(serverState, checkEnabled);
        this.zkClient.create(PARENT_PATH, DATA, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT, null);
        this.zkClient.create(CHILD_PATH, DATA, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT, null);
        long lastxid = this.zkConnected.getLastLoggedZxid();
        try {
            this.zkClientB.delete(CHILD_PATH, -1);
            Assertions.fail((String)"expect no auth");
        }
        catch (KeeperException.NoAuthException noAuthException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.connectedServer.getInProcess(), (String)"OutstandingRequests not decremented");
        this.assertTransactionState("failed delete", this.zkConnected, lastxid);
        this.assertTransactionState("failed delete", this.zkLeader, lastxid);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testSetDataOK(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.setUp(serverState, checkEnabled);
        this.zkClient.create(PARENT_PATH, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, null);
        this.zkClientB.setData(PARENT_PATH, DATA, -1);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testSetDataFail(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.setUp(serverState, checkEnabled);
        this.zkClient.create(PARENT_PATH, null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT, null);
        long lastxid = this.zkConnected.getLastLoggedZxid();
        try {
            this.zkClientB.setData(PARENT_PATH, DATA, -1);
            Assertions.fail((String)"expect no auth");
        }
        catch (KeeperException.NoAuthException noAuthException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.connectedServer.getInProcess(), (String)"OutstandingRequests not decremented");
        this.assertTransactionState("failed setData", this.zkConnected, lastxid);
        this.assertTransactionState("failed setData", this.zkLeader, lastxid);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testSetACLOK(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.setUp(serverState, checkEnabled);
        this.zkClient.create(PARENT_PATH, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, null);
        this.zkClientB.setACL(PARENT_PATH, ZooDefs.Ids.READ_ACL_UNSAFE, -1);
        Assertions.assertEquals((int)0, (int)this.connectedServer.getInProcess(), (String)"OutstandingRequests not decremented");
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testSetACLFail(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.setUp(serverState, checkEnabled);
        this.zkClient.create(PARENT_PATH, null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT, null);
        long lastxid = this.zkConnected.getLastLoggedZxid();
        try {
            this.zkClientB.setACL(PARENT_PATH, ZooDefs.Ids.READ_ACL_UNSAFE, -1);
            Assertions.fail((String)"expect no auth");
        }
        catch (KeeperException.NoAuthException noAuthException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.connectedServer.getInProcess(), (String)"OutstandingRequests not decremented");
        this.assertTransactionState("failed setACL", this.zkConnected, lastxid);
        this.assertTransactionState("failed setACL", this.zkLeader, lastxid);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testBadACL(QuorumPeer.ServerState serverState, boolean checkEnabled) throws Exception {
        this.setUp(serverState, checkEnabled);
        ClientBase.CountdownWatcher cw = new ClientBase.CountdownWatcher();
        String addr = String.format("%s:%d", "127.0.0.1", this.zkConnected.getClientPort());
        TestableZooKeeper zk = this.createClient(cw, addr);
        cw.waitForConnected(CONNECTION_TIMEOUT);
        long lastxid = this.zkConnected.getLastLoggedZxid();
        try {
            zk.create("/acltest", new byte[0], ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            Assertions.fail((String)"Should have received an invalid acl error");
        }
        catch (KeeperException.InvalidACLException invalidACLException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)this.connectedServer.getInProcess(), (String)"OutstandingRequests not decremented");
        this.assertTransactionState("invalid ACL", this.zkConnected, lastxid);
        this.assertTransactionState("invalid ACL", this.zkLeader, lastxid);
    }
}

