/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.util.fst;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTCompiler;
import org.apache.lucene.util.fst.FSTReader;
import org.apache.lucene.util.fst.IntsRefFSTEnum;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.Util;
import org.junit.Assert;

public class FSTTester<T> {
    public final Random random;
    public final List<InputOutput<T>> pairs;
    public final int inputMode;
    public final Outputs<T> outputs;
    public final Directory dir;
    public long nodeCount;
    public long arcCount;

    public FSTTester(Random random, Directory dir, int inputMode, List<InputOutput<T>> pairs, Outputs<T> outputs) {
        this.random = random;
        this.dir = dir;
        this.inputMode = inputMode;
        this.pairs = pairs;
        this.outputs = outputs;
    }

    static String inputToString(int inputMode, IntsRef term) {
        return FSTTester.inputToString(inputMode, term, true);
    }

    static String inputToString(int inputMode, IntsRef term, boolean isValidUnicode) {
        if (!isValidUnicode) {
            return term.toString();
        }
        if (inputMode == 0) {
            return FSTTester.toBytesRef(term).utf8ToString() + " " + term;
        }
        return UnicodeUtil.newString((int[])term.ints, (int)term.offset, (int)term.length) + " " + term;
    }

    private static BytesRef toBytesRef(IntsRef ir) {
        BytesRef br = new BytesRef(ir.length);
        for (int i = 0; i < ir.length; ++i) {
            int x = ir.ints[ir.offset + i];
            assert (x >= 0 && x <= 255);
            br.bytes[i] = (byte)x;
        }
        br.length = ir.length;
        return br;
    }

    public static String getRandomString(Random random) {
        String term = random.nextBoolean() ? TestUtil.randomRealisticUnicodeString(random) : FSTTester.simpleRandomString(random);
        return term;
    }

    public static String simpleRandomString(Random r) {
        int end = r.nextInt(10);
        if (end == 0) {
            return "";
        }
        char[] buffer = new char[end];
        for (int i = 0; i < end; ++i) {
            buffer[i] = (char)TestUtil.nextInt(r, 97, 102);
        }
        return new String(buffer, 0, end);
    }

    public static IntsRef toIntsRef(String s, int inputMode) {
        return FSTTester.toIntsRef(s, inputMode, new IntsRefBuilder());
    }

    public static IntsRef toIntsRef(String s, int inputMode, IntsRefBuilder ir) {
        if (inputMode == 0) {
            return FSTTester.toIntsRef(new BytesRef((CharSequence)s), ir);
        }
        return FSTTester.toIntsRefUTF32(s, ir);
    }

    static IntsRef toIntsRefUTF32(String s, IntsRefBuilder ir) {
        int charLength = s.length();
        int charIdx = 0;
        int intIdx = 0;
        ir.clear();
        while (charIdx < charLength) {
            ir.grow(intIdx + 1);
            int utf32 = s.codePointAt(charIdx);
            ir.append(utf32);
            charIdx += Character.charCount(utf32);
            ++intIdx;
        }
        return ir.get();
    }

    static IntsRef toIntsRef(BytesRef br, IntsRefBuilder ir) {
        ir.growNoCopy(br.length);
        ir.clear();
        for (int i = 0; i < br.length; ++i) {
            ir.append(br.bytes[br.offset + i] & 0xFF);
        }
        return ir.get();
    }

    private T run(FST<T> fst, IntsRef term, int[] prefixLength) throws IOException {
        assert (prefixLength == null || prefixLength.length == 1);
        FST.Arc arc = fst.getFirstArc(new FST.Arc());
        Object output = fst.outputs.getNoOutput();
        FST.BytesReader fstReader = fst.getBytesReader();
        for (int i = 0; i <= term.length; ++i) {
            int label = i == term.length ? -1 : term.ints[term.offset + i];
            if (fst.findTargetArc(label, arc, arc, fstReader) == null) {
                if (prefixLength != null) {
                    prefixLength[0] = i;
                    return (T)output;
                }
                return null;
            }
            output = fst.outputs.add(output, arc.output());
        }
        if (prefixLength != null) {
            prefixLength[0] = term.length;
        }
        return (T)output;
    }

    private T randomAcceptedWord(FST<T> fst, IntsRefBuilder in) throws IOException {
        FST.Arc arc = fst.getFirstArc(new FST.Arc());
        ArrayList<FST.Arc> arcs = new ArrayList<FST.Arc>();
        in.clear();
        Object output = fst.outputs.getNoOutput();
        FST.BytesReader fstReader = fst.getBytesReader();
        while (true) {
            fst.readFirstTargetArc(arc, arc, fstReader);
            arcs.add(new FST.Arc().copyFrom(arc));
            while (!arc.isLast()) {
                fst.readNextArc(arc, fstReader);
                arcs.add(new FST.Arc().copyFrom(arc));
            }
            arc = (FST.Arc)arcs.get(this.random.nextInt(arcs.size()));
            arcs.clear();
            output = fst.outputs.add(output, arc.output());
            if (arc.label() == -1) break;
            in.append(arc.label());
        }
        return (T)output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FST<T> doTest() throws IOException {
        FST fst;
        FSTCompiler fstCompiler;
        block36: {
            FST.FSTMetadata fstMetadata;
            block38: {
                FSTCompiler.Builder fstCompilerBuilder = new FSTCompiler.Builder(this.inputMode == 0 ? FST.INPUT_TYPE.BYTE1 : FST.INPUT_TYPE.BYTE4, this.outputs);
                IndexOutput indexOutput = null;
                boolean useOffHeap = this.random.nextBoolean();
                if (useOffHeap) {
                    indexOutput = this.dir.createOutput("fstOffHeap.bin", IOContext.DEFAULT);
                    fstCompilerBuilder.dataOutput((DataOutput)indexOutput);
                }
                fstCompiler = fstCompilerBuilder.build();
                for (InputOutput<T> pair : this.pairs) {
                    if (pair.output instanceof List) {
                        List longValues = (List)pair.output;
                        FSTCompiler fstCompilerObject = fstCompiler;
                        for (Long value : longValues) {
                            fstCompilerObject.add(pair.input, (Object)value);
                        }
                        continue;
                    }
                    fstCompiler.add(pair.input, pair.output);
                }
                fst = null;
                fstMetadata = fstCompiler.compile();
                if (!useOffHeap) break block38;
                indexOutput.close();
                if (fstMetadata == null) {
                    this.dir.deleteFile("fstOffHeap.bin");
                    break block36;
                } else {
                    try (IndexInput in = this.dir.openInput("fstOffHeap.bin", IOContext.DEFAULT);){
                        fst = new FST(fstMetadata, (DataInput)in);
                        break block36;
                    }
                    finally {
                        this.dir.deleteFile("fstOffHeap.bin");
                    }
                }
            }
            if (fstMetadata != null) {
                fst = FST.fromFSTReader((FST.FSTMetadata)fstMetadata, (FSTReader)fstCompiler.getFSTReader());
                if (this.random.nextBoolean()) {
                    IOContext context = LuceneTestCase.newIOContext(this.random);
                    try (IndexOutput out = this.dir.createOutput("fst.bin", context);){
                        fst.save((DataOutput)out, (DataOutput)out);
                    }
                    try (IndexInput in = this.dir.openInput("fst.bin", context);){
                        fst = new FST(FST.readMetadata((DataInput)in, this.outputs), (DataInput)in);
                    }
                    finally {
                        this.dir.deleteFile("fst.bin");
                    }
                }
            }
        }
        if (LuceneTestCase.VERBOSE && this.pairs.size() <= 20 && fst != null) {
            System.out.println("Printing FST as dot file to stdout:");
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset());
            Util.toDot((FST)fst, (Writer)w, (boolean)false, (boolean)false);
            ((Writer)w).flush();
            System.out.println("END dot file");
        }
        if (LuceneTestCase.VERBOSE) {
            if (fst == null) {
                System.out.println("  fst has 0 nodes (fully pruned)");
            } else {
                System.out.println("  fst has " + fstCompiler.getNodeCount() + " nodes and " + fstCompiler.getArcCount() + " arcs");
            }
        }
        this.verifyUnPruned(this.inputMode, fst);
        this.nodeCount = fstCompiler.getNodeCount();
        this.arcCount = fstCompiler.getArcCount();
        return fst;
    }

    protected boolean outputsEqual(T a, T b) {
        return a.equals(b);
    }

    private void verifyUnPruned(int inputMode, FST<T> fst) throws IOException {
        int iter;
        T output;
        if (this.pairs.size() == 0) {
            Assert.assertNull(fst);
            return;
        }
        if (LuceneTestCase.VERBOSE) {
            System.out.println("TEST: now verify " + this.pairs.size() + " terms");
            for (InputOutput<T> inputOutput : this.pairs) {
                Assert.assertNotNull(inputOutput);
                Assert.assertNotNull((Object)inputOutput.input);
                Assert.assertNotNull(inputOutput.output);
                System.out.println("  " + FSTTester.inputToString(inputMode, inputOutput.input) + ": " + this.outputs.outputToString(inputOutput.output));
            }
        }
        Assert.assertNotNull(fst);
        if (LuceneTestCase.VERBOSE) {
            System.out.println("TEST: check valid terms/next()");
        }
        IntsRefFSTEnum fstEnum = new IntsRefFSTEnum(fst);
        for (InputOutput<T> pair : this.pairs) {
            IntsRef term = pair.input;
            if (LuceneTestCase.VERBOSE) {
                System.out.println("TEST: check term=" + FSTTester.inputToString(inputMode, term) + " output=" + fst.outputs.outputToString(pair.output));
            }
            output = this.run(fst, term, null);
            Assert.assertNotNull((String)("term " + FSTTester.inputToString(inputMode, term) + " is not accepted"), output);
            Assert.assertTrue((boolean)this.outputsEqual(pair.output, output));
            IntsRefFSTEnum.InputOutput t = fstEnum.next();
            Assert.assertNotNull((Object)t);
            Assert.assertEquals((String)("expected input=" + FSTTester.inputToString(inputMode, term) + " but fstEnum returned " + FSTTester.inputToString(inputMode, t.input)), (Object)term, (Object)t.input);
            Assert.assertTrue((boolean)this.outputsEqual(pair.output, t.output));
        }
        Assert.assertNull((Object)fstEnum.next());
        HashMap termsMap = new HashMap();
        for (InputOutput<T> pair : this.pairs) {
            termsMap.put(pair.input, pair.output);
        }
        if (LuceneTestCase.VERBOSE) {
            System.out.println("TEST: verify random accepted terms");
        }
        IntsRefBuilder intsRefBuilder = new IntsRefBuilder();
        int num = LuceneTestCase.atLeast(this.random, 500);
        for (int iter2 = 0; iter2 < num; ++iter2) {
            output = this.randomAcceptedWord(fst, intsRefBuilder);
            Assert.assertTrue((String)("accepted word " + FSTTester.inputToString(inputMode, intsRefBuilder.get()) + " is not valid"), (boolean)termsMap.containsKey(intsRefBuilder.get()));
            Assert.assertTrue((boolean)this.outputsEqual(termsMap.get(intsRefBuilder.get()), output));
        }
        if (LuceneTestCase.VERBOSE) {
            System.out.println("TEST: verify seek");
        }
        IntsRefFSTEnum fstEnum2 = new IntsRefFSTEnum(fst);
        num = LuceneTestCase.atLeast(this.random, 100);
        for (iter = 0; iter < num; ++iter) {
            IntsRefFSTEnum.InputOutput seekResult;
            if (LuceneTestCase.VERBOSE) {
                System.out.println("  iter=" + iter);
            }
            if (this.random.nextBoolean()) {
                IntsRefFSTEnum.InputOutput seekResult2;
                IntsRef term;
                int pos;
                while ((pos = Collections.binarySearch(this.pairs, new InputOutput<Object>(term = FSTTester.toIntsRef(FSTTester.getRandomString(this.random), inputMode), null))) >= 0) {
                }
                pos = -(pos + 1);
                if (this.random.nextInt(3) == 0) {
                    if (LuceneTestCase.VERBOSE) {
                        System.out.println("  do non-exist seekExact term=" + FSTTester.inputToString(inputMode, term));
                    }
                    IntsRefFSTEnum.InputOutput seekResult22 = fstEnum2.seekExact(term);
                    pos = -1;
                } else if (this.random.nextBoolean()) {
                    if (LuceneTestCase.VERBOSE) {
                        System.out.println("  do non-exist seekFloor term=" + FSTTester.inputToString(inputMode, term));
                    }
                    seekResult2 = fstEnum2.seekFloor(term);
                    --pos;
                } else {
                    if (LuceneTestCase.VERBOSE) {
                        System.out.println("  do non-exist seekCeil term=" + FSTTester.inputToString(inputMode, term));
                    }
                    seekResult2 = fstEnum2.seekCeil(term);
                }
                if (pos != -1 && pos < this.pairs.size()) {
                    Assert.assertNotNull((String)("got null but expected term=" + FSTTester.inputToString(inputMode, this.pairs.get((int)pos).input)), (Object)seekResult2);
                    if (LuceneTestCase.VERBOSE) {
                        System.out.println("    got " + FSTTester.inputToString(inputMode, seekResult2.input));
                    }
                    Assert.assertEquals((String)("expected " + FSTTester.inputToString(inputMode, this.pairs.get((int)pos).input) + " but got " + FSTTester.inputToString(inputMode, seekResult2.input)), (Object)this.pairs.get((int)pos).input, (Object)seekResult2.input);
                    Assert.assertTrue((boolean)this.outputsEqual(this.pairs.get((int)pos).output, seekResult2.output));
                    continue;
                }
                Assert.assertNull((String)("expected null but got " + (seekResult2 == null ? "null" : FSTTester.inputToString(inputMode, seekResult2.input))), (Object)seekResult2);
                if (!LuceneTestCase.VERBOSE) continue;
                System.out.println("    got null");
                continue;
            }
            InputOutput<T> pair = this.pairs.get(this.random.nextInt(this.pairs.size()));
            if (this.random.nextInt(3) == 2) {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("  do exists seekExact term=" + FSTTester.inputToString(inputMode, pair.input));
                }
                seekResult = fstEnum2.seekExact(pair.input);
            } else if (this.random.nextBoolean()) {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("  do exists seekFloor " + FSTTester.inputToString(inputMode, pair.input));
                }
                seekResult = fstEnum2.seekFloor(pair.input);
            } else {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("  do exists seekCeil " + FSTTester.inputToString(inputMode, pair.input));
                }
                seekResult = fstEnum2.seekCeil(pair.input);
            }
            Assert.assertNotNull((Object)seekResult);
            Assert.assertEquals((String)("got " + FSTTester.inputToString(inputMode, seekResult.input) + " but expected " + FSTTester.inputToString(inputMode, pair.input)), (Object)pair.input, (Object)seekResult.input);
            Assert.assertTrue((boolean)this.outputsEqual(pair.output, seekResult.output));
        }
        if (LuceneTestCase.VERBOSE) {
            System.out.println("TEST: mixed next/seek");
        }
        num = LuceneTestCase.atLeast(this.random, 100);
        for (iter = 0; iter < num; ++iter) {
            boolean isDone;
            if (LuceneTestCase.VERBOSE) {
                System.out.println("TEST: iter " + iter);
            }
            fstEnum2 = new IntsRefFSTEnum(fst);
            int upto = -1;
            while (true) {
                isDone = false;
                if (upto == this.pairs.size() - 1 || this.random.nextBoolean()) {
                    ++upto;
                    if (LuceneTestCase.VERBOSE) {
                        System.out.println("  do next");
                    }
                    isDone = fstEnum2.next() == null;
                } else if (upto != -1 && (double)upto < 0.75 * (double)this.pairs.size() && this.random.nextBoolean()) {
                    int attempt;
                    for (attempt = 0; attempt < 10; ++attempt) {
                        IntsRef term = FSTTester.toIntsRef(FSTTester.getRandomString(this.random), inputMode);
                        if (termsMap.containsKey(term) || term.compareTo(this.pairs.get((int)upto).input) <= 0) continue;
                        int pos = Collections.binarySearch(this.pairs, new InputOutput<Object>(term, null));
                        assert (pos < 0);
                        upto = -(pos + 1);
                        if (this.random.nextBoolean()) {
                            Assert.assertTrue((--upto != -1 ? 1 : 0) != 0);
                            if (LuceneTestCase.VERBOSE) {
                                System.out.println("  do non-exist seekFloor(" + FSTTester.inputToString(inputMode, term) + ")");
                            }
                            isDone = fstEnum2.seekFloor(term) == null;
                            break;
                        }
                        if (LuceneTestCase.VERBOSE) {
                            System.out.println("  do non-exist seekCeil(" + FSTTester.inputToString(inputMode, term) + ")");
                        }
                        isDone = fstEnum2.seekCeil(term) == null;
                        break;
                    }
                    if (attempt == 10) {
                        continue;
                    }
                } else {
                    int inc;
                    if ((upto += (inc = this.random.nextInt(this.pairs.size() - upto - 1))) == -1) {
                        upto = 0;
                    }
                    if (this.random.nextBoolean()) {
                        if (LuceneTestCase.VERBOSE) {
                            System.out.println("  do seekCeil(" + FSTTester.inputToString(inputMode, this.pairs.get((int)upto).input) + ")");
                        }
                        isDone = fstEnum2.seekCeil(this.pairs.get((int)upto).input) == null;
                    } else {
                        if (LuceneTestCase.VERBOSE) {
                            System.out.println("  do seekFloor(" + FSTTester.inputToString(inputMode, this.pairs.get((int)upto).input) + ")");
                        }
                        boolean bl = isDone = fstEnum2.seekFloor(this.pairs.get((int)upto).input) == null;
                    }
                }
                if (LuceneTestCase.VERBOSE) {
                    if (!isDone) {
                        System.out.println("    got " + FSTTester.inputToString(inputMode, fstEnum2.current().input));
                    } else {
                        System.out.println("    got null");
                    }
                }
                if (upto == this.pairs.size()) break;
                Assert.assertFalse((boolean)isDone);
                Assert.assertEquals((Object)this.pairs.get((int)upto).input, (Object)fstEnum2.current().input);
                Assert.assertTrue((boolean)this.outputsEqual(this.pairs.get((int)upto).output, fstEnum2.current().output));
            }
            Assert.assertTrue((boolean)isDone);
        }
    }

    public static class InputOutput<T>
    implements Comparable<InputOutput<T>> {
        public final IntsRef input;
        public final T output;

        public InputOutput(IntsRef input, T output) {
            this.input = input;
            this.output = output;
        }

        @Override
        public int compareTo(InputOutput<T> other) {
            return this.input.compareTo(other.input);
        }
    }
}

