/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingComparator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorArray;
import org.apache.jena.atlas.iterator.IteratorDelayedInitialization;
import org.apache.jena.atlas.lib.ReverseComparator;

public class QueryIterTopN
extends QueryIterPlainWrapper {
    private final QueryIterator embeddedIterator;
    private PriorityQueue<Binding> heap;
    private long limit;
    private final boolean distinct;

    public QueryIterTopN(QueryIterator qIter, List<SortCondition> conditions, long numItems, boolean distinct, ExecutionContext context) {
        this(qIter, new BindingComparator(conditions, context), numItems, distinct, context);
    }

    public QueryIterTopN(QueryIterator qIter, Comparator<Binding> comparator, long numItems, boolean distinct, ExecutionContext context) {
        super(null, context);
        this.embeddedIterator = qIter;
        this.distinct = distinct;
        this.limit = numItems;
        if (this.limit == Long.MIN_VALUE) {
            this.limit = Long.MAX_VALUE;
        }
        if (this.limit < 0L) {
            throw new QueryExecException("Negative LIMIT: " + this.limit);
        }
        if (this.limit == 0L) {
            Iterator<Binding> iter0 = Iter.nullIterator();
            this.setIterator(iter0);
            qIter.close();
            return;
        }
        this.heap = new PriorityQueue<Binding>((int)numItems, new ReverseComparator<Binding>(comparator));
        this.setIterator(this.sortTopN(qIter, comparator));
    }

    @Override
    public void requestCancel() {
        this.embeddedIterator.cancel();
        super.requestCancel();
    }

    private Iterator<Binding> sortTopN(final QueryIterator qIter, final Comparator<Binding> comparator) {
        return new IteratorDelayedInitialization<Binding>(){

            @Override
            protected Iterator<Binding> initializeIterator() {
                while (qIter.hasNext()) {
                    Binding binding = (Binding)qIter.next();
                    if ((long)QueryIterTopN.this.heap.size() < QueryIterTopN.this.limit) {
                        QueryIterTopN.this.add(binding);
                        continue;
                    }
                    Binding currentMaxLeastN = (Binding)QueryIterTopN.this.heap.peek();
                    if (comparator.compare(binding, currentMaxLeastN) >= 0) continue;
                    QueryIterTopN.this.add(binding);
                }
                qIter.close();
                Binding[] y = QueryIterTopN.this.heap.toArray(new Binding[0]);
                QueryIterTopN.this.heap = null;
                Arrays.sort(y, comparator);
                IteratorArray<Binding> iter = IteratorArray.create(y);
                return iter;
            }
        };
    }

    private void add(Binding binding) {
        if (this.distinct && this.heap.contains(binding)) {
            return;
        }
        if ((long)this.heap.size() >= this.limit) {
            this.heap.poll();
        }
        this.heap.add(binding);
    }
}

