/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.impl;

import com.ibm.lsid.LSID;
import com.ibm.lsid.client.LSIDResolver;
import com.ibm.lsid.client.cache.LSIDCache;
import com.ibm.lsid.client.cache.LSIDCacheException;
import com.ibm.lsid.server.LSIDDataService;
import com.ibm.lsid.server.LSIDRequestContext;
import com.ibm.lsid.server.LSIDServerException;
import com.ibm.lsid.server.LSIDServiceConfig;
import java.io.InputStream;
import java.util.Map;

public class CachingDataService
implements LSIDDataService {
    private LSIDDataService service;
    private LSIDCache cache;

    public CachingDataService(LSIDDataService service) {
        this.service = service;
    }

    public InputStream getData(LSIDRequestContext ctx) throws LSIDServerException {
        LSID lsid = ctx.getLsid();
        Map headers = ctx.getProtocalHeaders();
        if (this.cache != null && !headers.containsValue("no-cache")) {
            try {
                InputStream stream = this.cache.readData(lsid, -1, -1);
                if (stream != null) {
                    return stream;
                }
                stream = this.service.getData(ctx);
                if (stream == null) {
                    throw new LSIDServerException(500, "getData should not return null");
                }
                return this.cache.writeData(lsid, stream, -1, -1);
            }
            catch (LSIDCacheException e) {
                throw new LSIDServerException((Exception)((Object)e), e.getErrorCode(), "cache exception in data lookup");
            }
        }
        return this.service.getData(ctx);
    }

    public InputStream getDataByRange(LSIDRequestContext ctx, int start, int length) throws LSIDServerException {
        LSID lsid = ctx.getLsid();
        Map headers = ctx.getProtocalHeaders();
        System.err.println(this.cache);
        System.err.println(headers.containsValue("no-cache"));
        if (this.cache != null && !headers.containsValue("no-cache")) {
            try {
                InputStream stream = this.cache.readData(lsid, start, length);
                if (stream != null) {
                    return stream;
                }
                stream = this.service.getDataByRange(ctx, start, length);
                if (stream == null) {
                    throw new LSIDServerException(500, "getData should not return null");
                }
                return this.cache.writeData(lsid, stream, start, length);
            }
            catch (LSIDCacheException e) {
                throw new LSIDServerException((Exception)((Object)e), e.getErrorCode(), "cache exception in data lookup");
            }
        }
        return this.service.getDataByRange(ctx, start, length);
    }

    public void initService(LSIDServiceConfig config) throws LSIDServerException {
        this.cache = LSIDResolver.getCache();
        if (this.cache == null) {
            throw new LSIDServerException(521, "Unable to load Authority Cache - environmental variable not set");
        }
        if (this.service == null) {
            throw new LSIDServerException(521, "Unable to load Authority Service");
        }
    }
}

