/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.security;

import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.Permission;
import uk.org.webcompere.systemstubs.security.AbortExecutionException;

public class NoExitSecurityManager
extends SecurityManager {
    private final SecurityManager originalSecurityManager;
    private Integer statusOfFirstExitCall = null;

    public NoExitSecurityManager(SecurityManager originalSecurityManager) {
        this.originalSecurityManager = originalSecurityManager;
    }

    @Override
    public void checkExit(int status) {
        if (this.statusOfFirstExitCall == null) {
            this.statusOfFirstExitCall = status;
        }
        throw new AbortExecutionException();
    }

    boolean isCheckExitCalled() {
        return this.statusOfFirstExitCall != null;
    }

    public int checkSystemExit() {
        if (this.isCheckExitCalled()) {
            return this.getStatusOfFirstCheckExitCall();
        }
        throw new AssertionError((Object)"System.exit has not been called.");
    }

    public Integer getExitCode() {
        if (this.isCheckExitCalled()) {
            return this.statusOfFirstExitCall;
        }
        return null;
    }

    private int getStatusOfFirstCheckExitCall() {
        if (this.isCheckExitCalled()) {
            return this.statusOfFirstExitCall;
        }
        throw new IllegalStateException("checkExit(int) has not been called.");
    }

    public boolean getInCheck() {
        return this.originalSecurityManager != null && this.originalSecurityManager.getInCheck();
    }

    @Override
    public Object getSecurityContext() {
        return this.originalSecurityManager == null ? super.getSecurityContext() : this.originalSecurityManager.getSecurityContext();
    }

    @Override
    public void checkPermission(Permission perm) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkPermission(perm);
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkPermission(perm, context);
        }
    }

    @Override
    public void checkCreateClassLoader() {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkCreateClassLoader();
        }
    }

    @Override
    public void checkAccess(Thread t) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkAccess(t);
        }
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkAccess(g);
        }
    }

    @Override
    public void checkExec(String cmd) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkExec(cmd);
        }
    }

    @Override
    public void checkLink(String lib) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkLink(lib);
        }
    }

    @Override
    public void checkRead(FileDescriptor fd) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkRead(fd);
        }
    }

    @Override
    public void checkRead(String file) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkRead(file);
        }
    }

    @Override
    public void checkRead(String file, Object context) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkRead(file, context);
        }
    }

    @Override
    public void checkWrite(FileDescriptor fd) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkWrite(fd);
        }
    }

    @Override
    public void checkWrite(String file) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkWrite(file);
        }
    }

    @Override
    public void checkDelete(String file) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkDelete(file);
        }
    }

    @Override
    public void checkConnect(String host, int port) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkConnect(host, port);
        }
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkConnect(host, port, context);
        }
    }

    @Override
    public void checkListen(int port) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkListen(port);
        }
    }

    @Override
    public void checkAccept(String host, int port) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkAccept(host, port);
        }
    }

    @Override
    public void checkMulticast(InetAddress maddr) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkMulticast(maddr);
        }
    }

    @Override
    public void checkMulticast(InetAddress maddr, byte ttl) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkMulticast(maddr, ttl);
        }
    }

    @Override
    public void checkPropertiesAccess() {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkPropertiesAccess();
        }
    }

    @Override
    public void checkPropertyAccess(String key) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkPropertyAccess(key);
        }
    }

    public boolean checkTopLevelWindow(Object window) {
        return this.originalSecurityManager == null ? super.checkTopLevelWindow(window) : this.originalSecurityManager.checkTopLevelWindow(window);
    }

    @Override
    public void checkPrintJobAccess() {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkPrintJobAccess();
        }
    }

    public void checkSystemClipboardAccess() {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkSystemClipboardAccess();
        }
    }

    public void checkAwtEventQueueAccess() {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkAwtEventQueueAccess();
        }
    }

    @Override
    public void checkPackageAccess(String pkg) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkPackageAccess(pkg);
        }
    }

    @Override
    public void checkPackageDefinition(String pkg) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkPackageDefinition(pkg);
        }
    }

    @Override
    public void checkSetFactory() {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkSetFactory();
        }
    }

    public void checkMemberAccess(Class<?> clazz, int which) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkMemberAccess(clazz, which);
        }
    }

    @Override
    public void checkSecurityAccess(String target) {
        if (this.originalSecurityManager != null) {
            this.originalSecurityManager.checkSecurityAccess(target);
        }
    }

    @Override
    public ThreadGroup getThreadGroup() {
        return this.originalSecurityManager == null ? super.getThreadGroup() : this.originalSecurityManager.getThreadGroup();
    }
}

