/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.client;

import edu.ucsb.nceas.metacat.client.DocumentNotFoundException;
import edu.ucsb.nceas.metacat.client.InsufficientKarmaException;
import edu.ucsb.nceas.metacat.client.Metacat;
import edu.ucsb.nceas.metacat.client.MetacatAuthException;
import edu.ucsb.nceas.metacat.client.MetacatException;
import edu.ucsb.nceas.metacat.client.MetacatInaccessibleException;
import edu.ucsb.nceas.utilities.HttpMessage;
import edu.ucsb.nceas.utilities.IOUtil;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetacatClient
implements Metacat {
    private String metacatUrl = null;
    private String sessionId = null;

    protected MetacatClient() {
    }

    public String login(String string, String string2) throws MetacatAuthException, MetacatInaccessibleException {
        Properties properties = new Properties();
        properties.put("action", "login");
        properties.put("qformat", "xml");
        properties.put("username", string);
        properties.put("password", string2);
        String string3 = null;
        try {
            string3 = this.sendDataForString(properties, null, null, 0);
        }
        catch (Exception exception) {
            throw new MetacatInaccessibleException(exception.getMessage());
        }
        if (string3.indexOf("<login>") == -1) {
            this.setSessionId("");
            throw new MetacatAuthException(string3);
        }
        int n = string3.indexOf("<sessionId>") + 11;
        int n2 = string3.indexOf("</sessionId>");
        if (n != -1 && n2 != -1) {
            this.setSessionId(string3.substring(n, n2));
        }
        return string3;
    }

    public String getloggedinuserinfo() throws MetacatInaccessibleException {
        Properties properties = new Properties();
        properties.put("action", "getloggedinuserinfo");
        properties.put("qformat", "xml");
        String string = null;
        try {
            string = this.sendDataForString(properties, null, null, 0);
        }
        catch (Exception exception) {
            throw new MetacatInaccessibleException(exception.getMessage());
        }
        return string;
    }

    public String logout() throws MetacatInaccessibleException, MetacatException {
        Properties properties = new Properties();
        properties.put("action", "logout");
        properties.put("qformat", "xml");
        String string = null;
        try {
            string = this.sendDataForString(properties, null, null, 0);
        }
        catch (Exception exception) {
            throw new MetacatInaccessibleException(exception.getMessage());
        }
        if (string.indexOf("<logout>") == -1) {
            throw new MetacatException(string);
        }
        this.setSessionId("");
        return string;
    }

    public Reader read(String string) throws InsufficientKarmaException, MetacatInaccessibleException, MetacatException, DocumentNotFoundException {
        PushbackReader pushbackReader = null;
        Properties properties = new Properties();
        properties.put("action", "read");
        properties.put("qformat", "xml");
        properties.put("docid", string);
        InputStream inputStream = null;
        try {
            inputStream = this.sendData(properties, null, null, 0);
        }
        catch (Exception exception) {
            throw new MetacatInaccessibleException(exception.getMessage());
        }
        pushbackReader = new PushbackReader(new InputStreamReader(inputStream), 512);
        try {
            char[] cArray = new char[512];
            int n = pushbackReader.read(cArray, 0, 512);
            StringWriter stringWriter = new StringWriter();
            stringWriter.write(cArray, 0, n);
            String string2 = stringWriter.toString();
            stringWriter.close();
            pushbackReader.unread(cArray, 0, n);
            if (string2.indexOf("<error>") != -1) {
                if (string2.indexOf("does not have permission") != -1) {
                    throw new InsufficientKarmaException(string2);
                }
                if (string2.indexOf("does not exist") != -1) {
                    throw new DocumentNotFoundException(string2);
                }
                throw new MetacatException(string2);
            }
        }
        catch (IOException iOException) {
            throw new MetacatException("MetacatClient: Error converting Reader to String." + iOException.getMessage());
        }
        return pushbackReader;
    }

    public Reader readInlineData(String string) throws InsufficientKarmaException, MetacatInaccessibleException, MetacatException {
        PushbackReader pushbackReader = null;
        Properties properties = new Properties();
        properties.put("action", "readinlinedata");
        properties.put("inlinedataid", string);
        InputStream inputStream = null;
        try {
            inputStream = this.sendData(properties, null, null, 0);
        }
        catch (Exception exception) {
            throw new MetacatInaccessibleException(exception.getMessage());
        }
        pushbackReader = new PushbackReader(new InputStreamReader(inputStream), 512);
        try {
            char[] cArray = new char[512];
            int n = pushbackReader.read(cArray, 0, 512);
            StringWriter stringWriter = new StringWriter();
            stringWriter.write(cArray, 0, n);
            String string2 = stringWriter.toString();
            stringWriter.close();
            pushbackReader.unread(cArray, 0, n);
            if (string2.indexOf("<error>") != -1) {
                if (string2.indexOf("does not have permission") != -1) {
                    throw new InsufficientKarmaException(string2);
                }
                throw new MetacatException(string2);
            }
        }
        catch (IOException iOException) {
            throw new MetacatException("MetacatClient: Error converting Reader to String." + iOException.getMessage());
        }
        return pushbackReader;
    }

    public Reader query(Reader reader) throws MetacatInaccessibleException, IOException {
        InputStreamReader inputStreamReader = null;
        String string = null;
        string = IOUtil.getAsString((Reader)reader, (boolean)true);
        Properties properties = new Properties();
        properties.put("action", "squery");
        properties.put("qformat", "xml");
        properties.put("query", string);
        InputStream inputStream = null;
        try {
            inputStream = this.sendData(properties, null, null, 0);
        }
        catch (Exception exception) {
            throw new MetacatInaccessibleException(exception.getMessage());
        }
        inputStreamReader = new InputStreamReader(inputStream);
        return inputStreamReader;
    }

    public String insert(String string, Reader reader, Reader reader2) throws InsufficientKarmaException, MetacatException, IOException, MetacatInaccessibleException {
        Object var4_4 = null;
        String string2 = null;
        String string3 = null;
        string2 = IOUtil.getAsString((Reader)reader, (boolean)true);
        if (reader2 != null) {
            string3 = IOUtil.getAsString((Reader)reader2, (boolean)true);
        }
        Properties properties = new Properties();
        properties.put("action", "insert");
        properties.put("docid", string);
        properties.put("doctext", string2);
        if (string3 != null) {
            properties.put("dtdtext", string3);
        }
        String string4 = null;
        try {
            string4 = this.sendDataForString(properties, null, null, 0);
        }
        catch (Exception exception) {
            throw new MetacatInaccessibleException(exception.getMessage());
        }
        if (string4.indexOf("<error>") != -1) {
            if (string4.indexOf("does not have permission") != -1) {
                throw new InsufficientKarmaException(string4);
            }
            throw new MetacatException(string4);
        }
        return string4;
    }

    public String update(String string, Reader reader, Reader reader2) throws InsufficientKarmaException, MetacatException, IOException, MetacatInaccessibleException {
        Object var4_4 = null;
        String string2 = null;
        String string3 = null;
        string2 = IOUtil.getAsString((Reader)reader, (boolean)true);
        if (reader2 != null) {
            string3 = IOUtil.getAsString((Reader)reader2, (boolean)true);
        }
        Properties properties = new Properties();
        properties.put("action", "update");
        properties.put("docid", string);
        properties.put("doctext", string2);
        if (string3 != null) {
            properties.put("dtdtext", string3);
        }
        String string4 = null;
        try {
            string4 = this.sendDataForString(properties, null, null, 0);
        }
        catch (Exception exception) {
            throw new MetacatInaccessibleException(exception.getMessage());
        }
        if (string4.indexOf("<error>") != -1) {
            if (string4.indexOf("does not have permission") != -1) {
                throw new InsufficientKarmaException(string4);
            }
            throw new MetacatException(string4);
        }
        return string4;
    }

    public String upload(String string, File file) throws InsufficientKarmaException, MetacatException, IOException, MetacatInaccessibleException {
        URL uRL = new URL(this.metacatUrl.trim());
        HttpMessage httpMessage = new HttpMessage(uRL);
        Properties properties = new Properties();
        properties.put("action", "upload");
        properties.put("docid", string);
        Properties properties2 = new Properties();
        String string2 = file.getAbsolutePath();
        properties2.put("datafile", string2);
        String string3 = null;
        try {
            string3 = this.sendDataForString(properties, properties2, null, 0);
        }
        catch (Exception exception) {
            throw new MetacatInaccessibleException(exception.getMessage());
        }
        if (string3.indexOf("<error>") != -1) {
            if (string3.indexOf("does not have permission") != -1) {
                throw new InsufficientKarmaException(string3);
            }
            throw new MetacatException(string3);
        }
        return string3;
    }

    public String upload(String string, String string2, InputStream inputStream, int n) throws InsufficientKarmaException, MetacatException, IOException, MetacatInaccessibleException {
        URL uRL = new URL(this.metacatUrl.trim());
        HttpMessage httpMessage = new HttpMessage(uRL);
        Properties properties = new Properties();
        properties.put("action", "upload");
        properties.put("docid", string);
        Properties properties2 = new Properties();
        properties2.put("datafile", string2);
        String string3 = null;
        try {
            string3 = this.sendDataForString(properties, properties2, inputStream, n);
        }
        catch (Exception exception) {
            throw new MetacatInaccessibleException(exception.getMessage());
        }
        if (string3.indexOf("<error>") != -1) {
            if (string3.indexOf("does not have permission") != -1) {
                throw new InsufficientKarmaException(string3);
            }
            throw new MetacatException(string3);
        }
        return string3;
    }

    public String delete(String string) throws InsufficientKarmaException, MetacatException, MetacatInaccessibleException {
        Properties properties = new Properties();
        properties.put("action", "delete");
        properties.put("docid", string);
        String string2 = null;
        try {
            string2 = this.sendDataForString(properties, null, null, 0);
        }
        catch (Exception exception) {
            throw new MetacatInaccessibleException(exception.getMessage());
        }
        if (string2.indexOf("<error>") != -1) {
            if (string2.indexOf("does not have permission") != -1) {
                throw new InsufficientKarmaException(string2);
            }
            throw new MetacatException(string2);
        }
        return string2;
    }

    public String setAccess(String string, String string2, String string3, String string4, String string5) throws InsufficientKarmaException, MetacatException, MetacatInaccessibleException {
        Properties properties = new Properties();
        properties.put("action", "setaccess");
        properties.put("docid", string);
        properties.put("principal", string2);
        properties.put("permission", string3);
        properties.put("permType", string4);
        properties.put("permOrder", string5);
        String string6 = null;
        try {
            string6 = this.sendDataForString(properties, null, null, 0);
        }
        catch (Exception exception) {
            throw new MetacatInaccessibleException(exception.getMessage());
        }
        if (string6.indexOf("<error>") != -1) {
            if (string6.indexOf("does not have permission") != -1) {
                throw new InsufficientKarmaException(string6);
            }
            throw new MetacatException(string6);
        }
        return string6;
    }

    public void setMetacatUrl(String string) {
        this.metacatUrl = string;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String string) {
        this.sessionId = string;
    }

    public int getNewestDocRevision(String string) throws MetacatException {
        int n = 0;
        Properties properties = new Properties();
        properties.put("action", "getrevisionanddoctype");
        properties.put("docid", string);
        String string2 = null;
        try {
            string2 = this.sendDataForString(properties, null, null, 0);
            String string3 = this.parserRevisionResponse(string2);
            Integer n2 = new Integer(string3);
            n = n2;
            if (string2.indexOf("<error>") != -1 && string3 == null) {
                throw new MetacatException(string2);
            }
        }
        catch (Exception exception) {
            throw new MetacatException(exception.getMessage());
        }
        return n;
    }

    public String getLastDocid(String string) throws MetacatException {
        String string2 = "";
        Properties properties = new Properties();
        properties.put("action", "getlastdocid");
        properties.put("scope", string);
        String string3 = null;
        try {
            string3 = this.sendDataForString(properties, null, null, 0);
            if (string3.indexOf("<error>") != -1) {
                throw new MetacatException(string3);
            }
            StringReader stringReader = new StringReader(string3);
            Node node = XMLUtilities.getXMLReaderAsDOMTreeRootNode((Reader)stringReader);
            Node node2 = XMLUtilities.getNodeWithXPath((Node)node, (String)"/lastDocid/docid");
            string2 = node2.getFirstChild().getNodeValue();
        }
        catch (Exception exception) {
            throw new MetacatException(exception.getMessage());
        }
        return string2;
    }

    public Vector getAllDocids(String string) throws MetacatException {
        Vector<String> vector = new Vector<String>();
        Properties properties = new Properties();
        properties.put("action", "getalldocids");
        if (string != null) {
            properties.put("scope", string);
        }
        String string2 = null;
        try {
            string2 = this.sendDataForString(properties, null, null, 0);
            if (string2.indexOf("<error>") != -1) {
                throw new MetacatException(string2);
            }
            StringReader stringReader = new StringReader(string2);
            Node node = XMLUtilities.getXMLReaderAsDOMTreeRootNode((Reader)stringReader);
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!node2.getNodeName().equals("docid")) continue;
                String string3 = node2.getFirstChild().getNodeValue();
                vector.addElement(string3);
            }
        }
        catch (Exception exception) {
            throw new MetacatException(exception.getMessage());
        }
        return vector;
    }

    public boolean isRegistered(String string) throws MetacatException {
        Vector vector = new Vector();
        Properties properties = new Properties();
        properties.put("action", "isregistered");
        if (string == null) {
            throw new MetacatException("<error>Cannot check if a null docid is registered.</error>");
        }
        properties.put("docid", string);
        String string2 = null;
        try {
            string2 = this.sendDataForString(properties, null, null, 0);
            if (string2.indexOf("<error>") != -1) {
                throw new MetacatException(string2);
            }
            StringReader stringReader = new StringReader(string2);
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[1024];
            int n = ((Reader)stringReader).read(cArray, 0, 1024);
            while (n != -1) {
                stringBuffer.append(new String(cArray, 0, n));
                n = ((Reader)stringReader).read(cArray, 0, 1024);
            }
            String string3 = stringBuffer.toString();
            return string3.indexOf("true") != -1;
        }
        catch (Exception exception) {
            throw new MetacatException(exception.getMessage());
        }
    }

    private synchronized InputStream sendDataOnce(Properties properties, Properties properties2, InputStream inputStream, int n) throws Exception {
        InputStream inputStream2 = null;
        URL uRL = new URL(this.metacatUrl);
        HttpMessage httpMessage = new HttpMessage(uRL);
        HttpMessage.setCookie((String)("JSESSIONID=" + this.sessionId));
        if (properties2 == null) {
            inputStream2 = httpMessage.sendPostData(properties);
        } else if (inputStream == null) {
            inputStream2 = httpMessage.sendPostData(properties, properties2);
        } else if (n > 0) {
            inputStream2 = httpMessage.sendPostData(properties, properties2, inputStream, n);
        } else {
            throw new MetacatException("Invalid size specified for the input stream being passed");
        }
        return inputStream2;
    }

    private synchronized InputStream sendData(Properties properties, Properties properties2, InputStream inputStream, int n) throws Exception {
        Object var5_5 = null;
        try {
            return this.sendDataOnce(properties, properties2, inputStream, n);
        }
        catch (Exception exception) {
            try {
                return this.sendDataOnce(properties, properties2, inputStream, n);
            }
            catch (Exception exception2) {
                try {
                    return this.sendDataOnce(properties, properties2, inputStream, n);
                }
                catch (Exception exception3) {
                    System.err.println("Failed to send data to metacat 3 times.");
                    throw exception3;
                }
            }
        }
    }

    private synchronized String sendDataForString(Properties properties, Properties properties2, InputStream inputStream, int n) throws Exception {
        int n2;
        String string = null;
        InputStreamReader inputStreamReader = new InputStreamReader(this.sendData(properties, properties2, inputStream, n));
        StringWriter stringWriter = new StringWriter();
        char[] cArray = new char[512];
        while ((n2 = inputStreamReader.read(cArray, 0, 512)) != -1) {
            stringWriter.write(cArray, 0, n2);
        }
        inputStreamReader.close();
        string = stringWriter.toString();
        stringWriter.close();
        return string;
    }

    private String parserRevisionResponse(String string) throws Exception {
        String string2 = null;
        if (string != null) {
            if (string.indexOf("<error>") != -1) {
                if (string.indexOf("There is not record") != -1) {
                    return "0";
                }
                return null;
            }
            int n = string.indexOf(";");
            string2 = string.substring(0, n);
        }
        return string2;
    }
}

