/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreCommittedLogTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(RestoreCommittedLogTest.class);
    private static final String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private static final int CONNECTION_TIMEOUT = 3000;

    @Test
    public void testRestoreCommittedLogWithSnapSize() throws Exception {
        int minExpectedSnapshots = 5;
        int minTxnsToSnap = 256;
        int numTransactions = 1280;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4096; ++i) {
            sb.append("0");
        }
        byte[] data = sb.toString().getBytes();
        SyncRequestProcessor.setSnapCount((int)1280000);
        SyncRequestProcessor.setSnapSizeInBytes((long)(256 * data.length));
        this.testRestoreCommittedLog(1280, data, 5);
    }

    @Test
    public void testRestoreCommittedLogWithSnapCount() throws Exception {
        int minExpectedSnapshots = 30;
        int snapCount = 100;
        SyncRequestProcessor.setSnapCount((int)100);
        SyncRequestProcessor.setSnapSizeInBytes((long)0x100000000L);
        this.testRestoreCommittedLog(3000, new byte[0], 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRestoreCommittedLog(int totalTransactions, byte[] data, int minExpectedSnapshots) throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L), (String)"waiting for server being up ");
        try (ZooKeeper zk = ClientBase.createZKClient(HOSTPORT);){
            for (int i = 0; i < totalTransactions; ++i) {
                zk.create("/invalidsnap-" + i, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        int numSnaps = zks.getTxnLogFactory().findNRecentSnapshots(10 * minExpectedSnapshots).size();
        LOG.info("number of snapshots taken {}", (Object)numSnaps);
        f.shutdown();
        zks.shutdown();
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown(HOSTPORT, 3000L), (String)"waiting for server to shutdown");
        Assertions.assertTrue((numSnaps > minExpectedSnapshots ? 1 : 0) != 0, (String)"too few snapshot files");
        Assertions.assertTrue((numSnaps <= minExpectedSnapshots * 2 ? 1 : 0) != 0, (String)"too many snapshot files");
        zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        zks.startdata();
        Collection committedLog = zks.getZKDatabase().getCommittedLog();
        int logsize = committedLog.size();
        LOG.info("committedLog size = {}", (Object)logsize);
        Assertions.assertTrue((logsize != 0 ? 1 : 0) != 0, (String)"log size != 0");
        zks.shutdown();
    }
}

