/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.MockPacket;
import org.apache.zookeeper.proto.ConnectRequest;
import org.apache.zookeeper.proto.ReplyHeader;
import org.apache.zookeeper.proto.RequestHeader;
import org.apache.zookeeper.proto.SetWatches;
import org.apache.zookeeper.server.MockNIOServerCnxn;
import org.apache.zookeeper.server.MockSelectorThread;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.Follower;
import org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchLeakTest {
    protected static final Logger LOG = LoggerFactory.getLogger(WatchLeakTest.class);
    final long SESSION_ID = 47806L;
    private static final long superSecret = 3007405056L;

    @BeforeEach
    public void setUp() {
        System.setProperty("zookeeper.admin.enableServer", "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testWatchesLeak(boolean sessionTimedout) throws Exception {
        NIOServerCnxnFactory serverCnxnFactory = (NIOServerCnxnFactory)Mockito.mock(NIOServerCnxnFactory.class);
        FakeSK sk = new FakeSK();
        MockSelectorThread selectorThread = (MockSelectorThread)((Object)Mockito.mock(MockSelectorThread.class));
        Mockito.when((Object)selectorThread.addInterestOpsUpdateRequest((SelectionKey)ArgumentMatchers.any(SelectionKey.class))).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                SelectionKey sk = (SelectionKey)invocation.getArguments()[0];
                NIOServerCnxn nioSrvCnx = (NIOServerCnxn)sk.attachment();
                sk.interestOps(nioSrvCnx.getInterestOps());
                return true;
            }
        });
        ZKDatabase database = new ZKDatabase(null);
        database.setlastProcessedZxid(2L);
        QuorumPeer quorumPeer = (QuorumPeer)Mockito.mock(QuorumPeer.class);
        FileTxnSnapLog logfactory = (FileTxnSnapLog)Mockito.mock(FileTxnSnapLog.class);
        Mockito.when((Object)logfactory.getDataLogDir()).thenReturn((Object)new File(""));
        Mockito.when((Object)logfactory.getSnapDir()).thenReturn((Object)new File(""));
        FollowerZooKeeperServer fzks = null;
        try {
            fzks = new FollowerZooKeeperServer(logfactory, quorumPeer, database);
            fzks.startup();
            fzks.setServerCnxnFactory((ServerCnxnFactory)serverCnxnFactory);
            quorumPeer.follower = new MyFollower(quorumPeer, fzks);
            LOG.info("Follower created");
            SocketChannel socketChannel = this.createClientSocketChannel();
            MockNIOServerCnxn nioCnxn = new MockNIOServerCnxn((ZooKeeperServer)fzks, socketChannel, sk, serverCnxnFactory, selectorThread);
            sk.attach((Object)nioCnxn);
            nioCnxn.doIO(sk);
            LOG.info("Client connection sent");
            QuorumPacket qp = this.createValidateSessionPacketResponse(!sessionTimedout);
            quorumPeer.follower.processPacket(qp);
            LOG.info("Session validation sent");
            nioCnxn.doIO(sk);
            Thread.sleep(1000L);
            LOG.info("Watches processed");
            int watchCount = database.getDataTree().getWatchCount();
            if (sessionTimedout) {
                LOG.info("session is not valid, watches = {}", (Object)watchCount);
                Assertions.assertEquals((int)0, (int)watchCount, (String)"Session is not valid so there should be no watches");
            } else {
                LOG.info("session is valid, watches = {}", (Object)watchCount);
                Assertions.assertEquals((int)1, (int)watchCount, (String)"Session is valid so the watch should be there");
            }
        }
        finally {
            if (fzks != null) {
                fzks.shutdown();
            }
        }
    }

    private ByteBuffer createWatchesMessage() {
        ArrayList<String> dataWatches = new ArrayList<String>(1);
        dataWatches.add("/");
        List existWatches = Collections.emptyList();
        List childWatches = Collections.emptyList();
        SetWatches sw = new SetWatches(1L, dataWatches, existWatches, childWatches);
        RequestHeader h = new RequestHeader();
        h.setType(101);
        h.setXid(-8);
        MockPacket p = new MockPacket(h, new ReplyHeader(), (Record)sw, null, null);
        return p.createAndReturnBB();
    }

    private ByteBuffer createConnRequest() {
        Random r = new Random(3007440574L);
        byte[] p = new byte[16];
        r.nextBytes(p);
        ConnectRequest conReq = new ConnectRequest(0, 1L, 30000, 47806L, p, false);
        MockPacket packet = new MockPacket(null, null, (Record)conReq, null, null);
        return packet.createAndReturnBB();
    }

    private SocketChannel createClientSocketChannel() throws IOException {
        SocketChannel socketChannel = (SocketChannel)Mockito.mock(SocketChannel.class);
        Socket socket = (Socket)Mockito.mock(Socket.class);
        InetSocketAddress socketAddress = new InetSocketAddress(1234);
        Mockito.when((Object)socket.getRemoteSocketAddress()).thenReturn((Object)socketAddress);
        Mockito.when((Object)socketChannel.socket()).thenReturn((Object)socket);
        ByteBuffer connRequest = this.createConnRequest();
        ByteBuffer watchesMessage = this.createWatchesMessage();
        final ByteBuffer request = ByteBuffer.allocate(connRequest.limit() + watchesMessage.limit());
        request.put(connRequest);
        request.put(watchesMessage);
        Answer<Integer> answer = new Answer<Integer>(){
            int i = 0;

            public Integer answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                ByteBuffer bb = (ByteBuffer)args[0];
                for (int k = 0; k < bb.limit(); ++k) {
                    bb.put(request.get(this.i));
                    ++this.i;
                }
                return bb.limit();
            }
        };
        Mockito.when((Object)socketChannel.read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class))).thenAnswer((Answer)answer);
        return socketChannel;
    }

    private QuorumPacket createValidateSessionPacketResponse(boolean valid) throws Exception {
        QuorumPacket qp = this.createValidateSessionPacket();
        ByteArrayInputStream bis = new ByteArrayInputStream(qp.getData());
        DataInputStream dis = new DataInputStream(bis);
        long id = dis.readLong();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeLong(id);
        dos.writeBoolean(valid);
        qp.setData(bos.toByteArray());
        return qp;
    }

    private QuorumPacket createValidateSessionPacket() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeLong(47806L);
        dos.writeInt(3000);
        dos.close();
        QuorumPacket qp = new QuorumPacket(6, -1L, baos.toByteArray(), null);
        return qp;
    }

    private static class FakeSK
    extends SelectionKey {
        private int ops = 5;

        private FakeSK() {
        }

        @Override
        public SelectableChannel channel() {
            return null;
        }

        @Override
        public Selector selector() {
            return (Selector)Mockito.mock(Selector.class);
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public void cancel() {
        }

        @Override
        public int interestOps() {
            return this.ops;
        }

        @Override
        public SelectionKey interestOps(int ops) {
            this.ops = ops;
            return this;
        }

        @Override
        public int readyOps() {
            boolean writing;
            boolean reading = (this.ops & 1) != 0;
            boolean bl = writing = (this.ops & 4) != 0;
            if (reading && writing) {
                LOG.info("Channel is ready for reading and writing");
            } else if (reading) {
                LOG.info("Channel is ready for reading only");
            } else if (writing) {
                LOG.info("Channel is ready for writing only");
            }
            return this.ops;
        }
    }

    public static class MyFollower
    extends Follower {
        MyFollower(QuorumPeer self, FollowerZooKeeperServer zk) {
            super(self, zk);
            this.leaderOs = (OutputArchive)Mockito.mock(OutputArchive.class);
            this.leaderIs = (InputArchive)Mockito.mock(InputArchive.class);
            this.bufferedOutput = (BufferedOutputStream)Mockito.mock(BufferedOutputStream.class);
        }
    }
}

