/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.persistence;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.jute.Record;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.DummyWatcher;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FilePadding;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.server.persistence.Util;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.txn.CreateTxn;
import org.apache.zookeeper.txn.TxnHeader;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTxnLogTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(FileTxnLogTest.class);
    private static final int KB = 1024;
    private static String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private static final int CONNECTION_TIMEOUT = 3000;
    private static final int NODE_SIZE = 1024;
    private final long PREALLOCATE = 512L;
    private final long LOG_SIZE_LIMIT = 4096L;

    @Test
    public void testInvalidPreallocSize() {
        Assertions.assertEquals((long)10240L, (long)FilePadding.calculateFileSizeWithPadding((long)7168L, (long)10240L, (long)0L), (String)"file should not be padded");
        Assertions.assertEquals((long)10240L, (long)FilePadding.calculateFileSizeWithPadding((long)7168L, (long)10240L, (long)-1L), (String)"file should not be padded");
    }

    @Test
    public void testCalculateFileSizeWithPaddingWhenNotToCurrentSize() {
        Assertions.assertEquals((long)10240L, (long)FilePadding.calculateFileSizeWithPadding((long)5120L, (long)10240L, (long)10240L), (String)"file should not be padded");
    }

    @Test
    public void testCalculateFileSizeWithPaddingWhenCloseToCurrentSize() {
        Assertions.assertEquals((long)20480L, (long)FilePadding.calculateFileSizeWithPadding((long)7168L, (long)10240L, (long)10240L), (String)"file should be padded an additional 10 KB");
    }

    @Test
    public void testFileSizeGreaterThanPosition() {
        Assertions.assertEquals((long)40960L, (long)FilePadding.calculateFileSizeWithPadding((long)31744L, (long)10240L, (long)10240L), (String)"file should be padded to 40 KB");
    }

    @Test
    public void testPreAllocSizeSmallerThanTxnData() throws IOException {
        File logDir = ClientBase.createTmpDir();
        FileTxnLog fileTxnLog = new FileTxnLog(logDir);
        int preAllocSize = 512000;
        FilePadding.setPreallocSize((long)512000L);
        byte[] data = new byte[1024000];
        Arrays.fill(data, (byte)-1);
        fileTxnLog.append(new Request(0L, 0, 0, new TxnHeader(1L, 1, 1L, 1L, 1), (Record)new CreateTxn("/testPreAllocSizeSmallerThanTxnData1", data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, false, 0), 0L));
        fileTxnLog.commit();
        fileTxnLog.append(new Request(0L, 0, 0, new TxnHeader(1L, 1, 2L, 2L, 1), (Record)new CreateTxn("/testPreAllocSizeSmallerThanTxnData2", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, false, 0), 0L));
        fileTxnLog.commit();
        fileTxnLog.close();
        FileTxnLog.FileTxnIterator fileTxnIterator = new FileTxnLog.FileTxnIterator(logDir, 0L);
        CreateTxn createTxn = (CreateTxn)fileTxnIterator.getTxn();
        Assertions.assertTrue((boolean)Arrays.equals(createTxn.getData(), data));
        fileTxnIterator.next();
        createTxn = (CreateTxn)fileTxnIterator.getTxn();
        Assertions.assertTrue((boolean)Arrays.equals(createTxn.getData(), new byte[0]));
    }

    @Test
    public void testSetPreallocSize() {
        long customPreallocSize = 10101L;
        FileTxnLog.setPreallocSize((long)customPreallocSize);
        MatcherAssert.assertThat((Object)FilePadding.getPreAllocSize(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)customPreallocSize)));
    }

    public void testSyncThresholdExceedCount() throws IOException {
        System.setProperty("zookeeper.fsync.warningthresholdms", "-1");
        ServerStats.Provider providerMock = (ServerStats.Provider)Mockito.mock(ServerStats.Provider.class);
        ServerStats serverStats = new ServerStats(providerMock);
        File logDir = ClientBase.createTmpDir();
        FileTxnLog fileTxnLog = new FileTxnLog(logDir);
        fileTxnLog.setServerStats(serverStats);
        Assertions.assertEquals((long)0L, (long)serverStats.getFsyncThresholdExceedCount());
        for (int i = 0; i < 50; ++i) {
            fileTxnLog.append(new Request(0L, 0, 0, new TxnHeader(1L, 1, 1L, 1L, 1), (Record)new CreateTxn("/testFsyncThresholdCountIncreased", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, false, 0), 0L));
            fileTxnLog.commit();
            Assertions.assertEquals((long)((long)i + 1L), (long)serverStats.getFsyncThresholdExceedCount());
        }
    }

    @Test
    public void testGetCurrentLogSize() throws Exception {
        FileTxnLog.setTxnLogSizeLimit((long)-1L);
        File tmpDir = ClientBase.createTmpDir();
        FileTxnLog log = new FileTxnLog(tmpDir);
        FileTxnLog.setPreallocSize((long)512L);
        CreateRequest record = new CreateRequest(null, new byte[1024], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, 0);
        long logSize = 0L;
        long position = 0L;
        int fileHeaderSize = 16;
        int zxid = 1;
        for (int i = 0; i < 4; ++i) {
            if (i == 0) {
                logSize += (long)fileHeaderSize;
                position += (long)fileHeaderSize;
            }
            log.append(new Request(0L, 0, 0, new TxnHeader(0L, 0, (long)zxid++, 0L, 0), (Record)record, 0L));
            Assertions.assertEquals((long)(logSize += 512L), (long)log.getCurrentLogSize());
            Assertions.assertEquals((long)position, (long)log.filePosition);
        }
        log.commit();
        TxnHeader mockHeader = new TxnHeader(0L, 0, 0L, 0L, 0);
        int totalSize = fileHeaderSize + this.calculateSingleRecordLength(mockHeader, (Record)record) * 4;
        Assertions.assertEquals((long)totalSize, (long)log.getCurrentLogSize());
        Assertions.assertEquals((long)totalSize, (long)log.filePosition);
        Assertions.assertTrue((log.getCurrentLogSize() > (long)((zxid - 1) * 1024) ? 1 : 0) != 0);
        logSize = FilePadding.calculateFileSizeWithPadding((long)log.filePosition, (long)2048L, (long)512L);
        position = totalSize;
        boolean recalculate = true;
        for (int i = 0; i < 4; ++i) {
            log.append(new Request(0L, 0, 0, new TxnHeader(0L, 0, (long)zxid++, 0L, 0), (Record)record, 0L));
            if (recalculate) {
                recalculate = false;
            } else {
                logSize += 512L;
            }
            Assertions.assertEquals((long)logSize, (long)log.getCurrentLogSize());
            Assertions.assertEquals((long)position, (long)log.filePosition);
        }
        log.commit();
        Assertions.assertEquals((long)(totalSize += this.calculateSingleRecordLength(mockHeader, (Record)record) * 4), (long)log.getCurrentLogSize());
        Assertions.assertEquals((long)totalSize, (long)log.filePosition);
        Assertions.assertTrue((log.getCurrentLogSize() > (long)((zxid - 1) * 1024) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogSizeLimit() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        FileTxnLog.setPreallocSize((long)512L);
        FileTxnLog.setTxnLogSizeLimit((long)4096L);
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp(HOSTPORT, 3000L), (String)"waiting for server being up ");
        ZooKeeper zk = new ZooKeeper(HOSTPORT, 3000, (Watcher)DummyWatcher.INSTANCE);
        HashSet<Long> zxids = new HashSet<Long>();
        byte[] bytes = new byte[1024];
        Random random = new Random();
        random.nextBytes(bytes);
        long txnCount = 10L;
        LOG.info("Creating {} txns", (Object)txnCount);
        try {
            for (long i = 0L; i < txnCount; ++i) {
                Stat stat = new Stat();
                zk.create("/node-" + i, bytes, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                zk.getData("/node-" + i, null, stat);
                zxids.add(stat.getCzxid());
            }
        }
        finally {
            zk.close();
        }
        f.shutdown();
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown(HOSTPORT, 3000L), (String)"waiting for server to shutdown");
        File logDir = new File(tmpDir, "version-2");
        File[] txnLogs = FileTxnLog.getLogFiles((File[])logDir.listFiles(), (long)0L);
        Assertions.assertEquals((int)3, (int)txnLogs.length, (String)"Unexpected number of logs");
        long threshold = 5120L;
        LOG.info(txnLogs[0].getAbsolutePath());
        Assertions.assertTrue((threshold > txnLogs[0].length() ? 1 : 0) != 0, (String)("Exceed log size limit: " + txnLogs[0].length()));
        LOG.info(txnLogs[1].getAbsolutePath());
        Assertions.assertTrue((threshold > txnLogs[1].length() ? 1 : 0) != 0, (String)("Exceed log size limit " + txnLogs[1].length()));
        zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        zks.startdata();
        ZKDatabase db = zks.getZKDatabase();
        for (long i = 0L; i < txnCount; ++i) {
            Stat stat = new Stat();
            byte[] data = db.getData("/node-" + i, stat, null);
            Assertions.assertArrayEquals((byte[])bytes, (byte[])data, (String)"Missmatch data");
            Assertions.assertTrue((boolean)zxids.contains(stat.getMzxid()), (String)"Unknown zxid ");
        }
    }

    private int calculateSingleRecordLength(TxnHeader txnHeader, Record record) throws IOException {
        int crcLength = 8;
        int dataLength = 4;
        int recordLength = Util.marshallTxnEntry((TxnHeader)txnHeader, (Record)record, null).length;
        int endFlagLength = 1;
        return crcLength + dataLength + recordLength + endFlagLength;
    }
}

