/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.osti_elink;

import edu.ucsb.nceas.osti_elink.OSTIElinkErrorAgent;
import edu.ucsb.nceas.osti_elink.OSTIElinkException;
import edu.ucsb.nceas.osti_elink.OSTIElinkService;
import edu.ucsb.nceas.osti_elink.OSTIElinkServiceRequest;
import edu.ucsb.nceas.osti_elink.OSTIServiceFactory;
import edu.ucsb.nceas.osti_elink.exception.ClassNotSupported;
import edu.ucsb.nceas.osti_elink.exception.PropertyNotFound;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OSTIElinkClient {
    public static final String USER_NAME_PROPERTY = "guid.doi.username";
    public static final String PASSWORD_PROPERTY = "guid.doi.password";
    public static final String BASE_URL_PROPERTY = "guid.doi.baseurl";
    private OSTIElinkErrorAgent errorAgent = null;
    private OSTIElinkService service = null;
    private ExecutorService executor = null;
    private static Properties properties = null;
    protected static Log log = LogFactory.getLog(OSTIElinkClient.class);

    public OSTIElinkClient(String username, String password, String baseURL, OSTIElinkErrorAgent errorAgent) {
        if (properties == null) {
            this.loadDefaultPropertyFile();
        }
        if (username != null) {
            properties.setProperty(USER_NAME_PROPERTY, username);
        }
        if (password != null) {
            properties.setProperty(PASSWORD_PROPERTY, password);
        }
        properties.setProperty(BASE_URL_PROPERTY, baseURL);
        try {
            this.service = OSTIServiceFactory.getOSTIElinkService(properties);
        }
        catch (OSTIElinkException | ClassNotSupported | PropertyNotFound | IOException | ClassNotFoundException | ParserConfigurationException e) {
            log.error((Object)("Can't generate the OSTIElinkService instance since " + e.getMessage()), (Throwable)e);
            throw new RuntimeException(e);
        }
        this.errorAgent = errorAgent;
        this.startExecutorLoop();
    }

    private void loadDefaultPropertyFile() {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("osti.properties");){
            properties = new Properties();
            properties.load(is);
        }
        catch (IOException e) {
            log.error((Object)("Can't load the default property file into properties " + e.getMessage()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void setProperties(Properties properties1) {
        properties = properties1;
    }

    public void setMetadata(String identifier, String metadata) throws InterruptedException {
        OSTIElinkServiceRequest request = new OSTIElinkServiceRequest(this.service, 1, identifier, this.errorAgent, metadata);
        this.executor.execute(request);
    }

    public String mintIdentifier(String siteCode) throws OSTIElinkException {
        String identifier = null;
        try {
            identifier = this.service.mintIdentifier(siteCode);
        }
        catch (OSTIElinkException e) {
            if (this.errorAgent != null) {
                this.errorAgent.notify(e.getMessage());
            }
            throw e;
        }
        return identifier;
    }

    public String getMetadata(String identifier) throws OSTIElinkException {
        return this.service.getMetadata(identifier);
    }

    public String getStatus(String identifier) throws OSTIElinkException {
        return this.service.getStatus(identifier);
    }

    private void startExecutorLoop() {
        Runtime runtime = Runtime.getRuntime();
        int numCores = runtime.availableProcessors();
        log.debug((Object)("OSTIElinkClient.startExecutorLoop - Number of cores available: " + numCores));
        this.executor = Executors.newFixedThreadPool(numCores);
    }

    public void shutdown() {
        log.debug((Object)"Shutting down executor...");
        this.executor.shutdown();
        while (!this.executor.isTerminated()) {
        }
    }

    public OSTIElinkService getService() {
        return this.service;
    }
}

