/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;

public class UpdateProcessorTestBase
extends SolrTestCaseJ4 {
    protected SolrInputDocument processAdd(String chain, SolrInputDocument docIn) throws IOException {
        return this.processAdd(chain, (SolrParams)new ModifiableSolrParams(), docIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrInputDocument processAdd(String chain, SolrParams requestParams, SolrInputDocument docIn) throws IOException {
        SolrCore core = h.getCore();
        UpdateRequestProcessorChain pc = core.getUpdateProcessingChain(chain);
        UpdateProcessorTestBase.assertNotNull((String)("No Chain named: " + chain), (Object)pc);
        SolrQueryResponse rsp = new SolrQueryResponse();
        LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, requestParams);
        try {
            SolrRequestInfo.setRequestInfo((SolrRequestInfo)new SolrRequestInfo((SolrQueryRequest)req, rsp));
            AddUpdateCommand cmd = new AddUpdateCommand((SolrQueryRequest)req);
            cmd.solrDoc = docIn;
            UpdateRequestProcessor processor = pc.createProcessor((SolrQueryRequest)req, rsp);
            if (null != processor) {
                processor.processAdd(cmd);
            }
            SolrInputDocument solrInputDocument = cmd.solrDoc;
            return solrInputDocument;
        }
        finally {
            SolrRequestInfo.clearRequestInfo();
            req.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processCommit(String chain) throws IOException {
        SolrCore core = h.getCore();
        UpdateRequestProcessorChain pc = core.getUpdateProcessingChain(chain);
        UpdateProcessorTestBase.assertNotNull((String)("No Chain named: " + chain), (Object)pc);
        SolrQueryResponse rsp = new SolrQueryResponse();
        LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, (SolrParams)new ModifiableSolrParams());
        CommitUpdateCommand cmd = new CommitUpdateCommand((SolrQueryRequest)req, false);
        UpdateRequestProcessor processor = pc.createProcessor((SolrQueryRequest)req, rsp);
        try {
            processor.processCommit(cmd);
        }
        finally {
            req.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDeleteById(String chain, String id) throws IOException {
        SolrCore core = h.getCore();
        UpdateRequestProcessorChain pc = core.getUpdateProcessingChain(chain);
        UpdateProcessorTestBase.assertNotNull((String)("No Chain named: " + chain), (Object)pc);
        SolrQueryResponse rsp = new SolrQueryResponse();
        LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, (SolrParams)new ModifiableSolrParams());
        DeleteUpdateCommand cmd = new DeleteUpdateCommand((SolrQueryRequest)req);
        cmd.setId(id);
        UpdateRequestProcessor processor = pc.createProcessor((SolrQueryRequest)req, rsp);
        try {
            processor.processDelete(cmd);
        }
        finally {
            req.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finish(String chain) throws IOException {
        SolrCore core = h.getCore();
        UpdateRequestProcessorChain pc = core.getUpdateProcessingChain(chain);
        UpdateProcessorTestBase.assertNotNull((String)("No Chain named: " + chain), (Object)pc);
        SolrQueryResponse rsp = new SolrQueryResponse();
        LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, (SolrParams)new ModifiableSolrParams());
        UpdateRequestProcessor processor = pc.createProcessor((SolrQueryRequest)req, rsp);
        try {
            processor.finish();
        }
        finally {
            IOUtils.closeQuietly((AutoCloseable)processor);
            req.close();
        }
    }

    protected final SolrInputDocument doc(SolrInputField ... fields) {
        SolrInputDocument d = new SolrInputDocument();
        for (SolrInputField f : fields) {
            d.put(f.getName(), f);
        }
        return d;
    }

    final SolrInputField field(String name, Object ... values) {
        SolrInputField f = new SolrInputField(name);
        for (Object v : values) {
            f.addValue(v);
        }
        return f;
    }

    protected final SolrInputField f(String name, Object ... values) {
        return this.field(name, values);
    }
}

