/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.dns;
import org.xbill.DNS.utils.MyStringTokenizer;

public final class Address {
    private Address() {
    }

    public static boolean isDottedQuad(String s) {
        MyStringTokenizer st = new MyStringTokenizer(s, ".");
        boolean labels = false;
        int[] values = new int[4];
        int i = 0;
        while (i < 4) {
            if (!st.hasMoreTokens()) break;
            try {
                values[i] = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException e) {
                break;
            }
            if (values[i] < 0 || values[i] > 255) break;
            ++i;
        }
        return i == 4 && !st.hasMoreDelimiters();
    }

    public static String toDottedQuad(byte[] addr) {
        return (addr[0] & 0xFF) + "." + (addr[1] & 0xFF) + "." + (addr[2] & 0xFF) + "." + (addr[3] & 0xFF);
    }

    public static InetAddress getByName(String name) throws UnknownHostException {
        if (Address.isDottedQuad(name)) {
            return InetAddress.getByName(name);
        }
        Record[] records = dns.getRecords(name, (short)1);
        if (records == null) {
            throw new UnknownHostException("unknown host");
        }
        ARecord a = (ARecord)records[0];
        return a.getAddress();
    }

    public static InetAddress[] getAllByName(String name) throws UnknownHostException {
        if (Address.isDottedQuad(name)) {
            return InetAddress.getAllByName(name);
        }
        Record[] records = dns.getRecords(name, (short)1);
        if (records == null) {
            throw new UnknownHostException("unknown host");
        }
        InetAddress[] addrs = new InetAddress[records.length];
        int i = 0;
        while (i < records.length) {
            ARecord a = (ARecord)records[i];
            addrs[i] = a.getAddress();
            ++i;
        }
        return addrs;
    }

    public static String getHostName(InetAddress addr) throws UnknownHostException {
        Record[] records = dns.getRecordsByAddress(addr.getHostAddress(), (short)12);
        if (records == null) {
            throw new UnknownHostException("unknown address");
        }
        PTRRecord ptr = (PTRRecord)records[0];
        return ptr.getTarget().toString();
    }
}

