/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.common.query;

import edu.ucsb.nceas.metacat.common.query.SolrQueryResponseTransformer;
import edu.ucsb.nceas.metacat.common.query.SolrQueryService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.util.Version;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IndexSchemaFactory;
import org.apache.solr.schema.SchemaField;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.types.v1.Subject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HttpSolrQueryService
extends SolrQueryService {
    private static final String SOLR_SYSTEMINFO_URLAPPENDIX = "solr.systeminfo.urlappendix";
    private static final String SOLR_SCHEMA_URLAPPENDIX = "solr.schema.urlappendix";
    private static final String SPEC_PATH = "//str[@name='solr-spec-version']";
    private String solrServerBaseURL = null;
    private HttpSolrClient httpSolrServer = null;
    private static Log log = LogFactory.getLog(HttpSolrQueryService.class);

    public HttpSolrQueryService(HttpSolrClient httpSolrServer) throws IOException {
        if (httpSolrServer == null) {
            throw new NullPointerException("HttpSolrQueryService.constructor - The httpSolrServer parameter can't be null");
        }
        this.httpSolrServer = httpSolrServer;
        this.solrServerBaseURL = httpSolrServer.getBaseURL();
        this.getIndexSchemaFieldFromServer();
    }

    @Override
    public InputStream query(SolrParams query, Set<Subject> subjects, SolrRequest.METHOD method) throws IOException, NotFound, UnsupportedType, SolrServerException {
        InputStream inputStream = null;
        String wt = query.get("wt");
        query = this.appendAccessFilterParams(query, subjects);
        SolrQueryResponseTransformer solrTransformer = new SolrQueryResponseTransformer(null);
        if (!HttpSolrQueryService.isSupportedWT(wt)) {
            throw new UnsupportedType("0000", "HttpSolrQueryService.query - the wt type " + wt + " in the solr query is not supported");
        }
        QueryResponse response = this.httpSolrServer.query(query, method);
        inputStream = solrTransformer.transformResults(query, response, wt);
        return inputStream;
    }

    @Override
    public Map<String, SchemaField> getIndexSchemaFields() throws IOException {
        if (this.fieldMap == null || this.fieldMap.isEmpty()) {
            this.getIndexSchemaFieldFromServer();
        }
        return this.fieldMap;
    }

    private void getIndexSchemaFieldFromServer() throws IOException {
        log.debug((Object)"get filed map from server (downloading files) ==========================");
        SolrResourceLoader loader = new SolrResourceLoader(Paths.get("", new String[0]));
        ConfigSetService service = null;
        ConfigSetService.ConfigResource configureResource = IndexSchemaFactory.getConfigResource(service, (InputStream)this.lookupSchema(), (SolrResourceLoader)loader, (String)"dataone");
        Properties substitutableProperties = new Properties();
        this.schema = new IndexSchema("dataone", configureResource, Version.LUCENE_8_8_2, loader, substitutableProperties);
        log.debug((Object)("Intialize the schema is +++++++++++++++++++++++++++++++++++++++++++++++++++" + String.valueOf(this.schema)));
        this.fieldMap = this.schema.getFields();
    }

    private InputStream lookupSchema() throws IOException {
        String schemaURLAppendix = Settings.getConfiguration().getString(SOLR_SCHEMA_URLAPPENDIX);
        String schemaURL = this.solrServerBaseURL + schemaURLAppendix;
        log.info((Object)("HttpSolrQueryService.lookupSchema - the url of getting the solr configure file is " + schemaURL));
        return new URL(schemaURL).openStream();
    }

    @Override
    public String getSolrServerVersion() {
        if (this.solrSpecVersion == null) {
            this.getHttpSolrServerVersion();
        }
        return this.solrSpecVersion;
    }

    private void getHttpSolrServerVersion() {
        String systemInfoUrlAppendix = Settings.getConfiguration().getString(SOLR_SYSTEMINFO_URLAPPENDIX);
        String systemInfoUrl = this.solrServerBaseURL + systemInfoUrlAppendix;
        try {
            Document doc = this.transformInputStreamToDoc(new URL(systemInfoUrl).openStream());
            NodeList nodeList = (NodeList)XPathFactory.newInstance().newXPath().evaluate(SPEC_PATH, doc, XPathConstants.NODESET);
            if (nodeList != null && nodeList.getLength() > 0) {
                Node specNode = nodeList.item(0);
                this.solrSpecVersion = specNode.getFirstChild().getNodeValue();
            } else {
                this.solrSpecVersion = "Unknown";
            }
        }
        catch (Exception e) {
            log.error((Object)("HttpSolrQueryService.getHttpSolrServerVersion - can't get the solr specification version since " + e.getMessage()));
            this.solrSpecVersion = "Unknown";
        }
    }

    private Document transformInputStreamToDoc(InputStream input) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        return dBuilder.parse(input);
    }
}

