/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.util.ArrayList;
import net.sourceforge.plantuml.json.Json;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.text.TLineType;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterExceptionLocated;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunctionArgument;
import net.sourceforge.plantuml.tim.TFunctionImpl;
import net.sourceforge.plantuml.tim.TFunctionType;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.tim.expression.Token;
import net.sourceforge.plantuml.tim.expression.TokenStack;
import net.sourceforge.plantuml.tim.expression.TokenType;
import net.sourceforge.plantuml.utils.LineLocation;

public abstract class Eater {
    private int i = 0;
    private final String s;
    private final LineLocation lineLocation;

    public Eater(StringLocated sl) {
        this(sl.getString(), sl.getLocation());
    }

    protected Eater(String s, LineLocation lineLocation) {
        this.s = s;
        this.lineLocation = lineLocation;
    }

    public final LineLocation getLineLocation() {
        return this.lineLocation;
    }

    public abstract void analyze(TContext var1, TMemory var2) throws EaterException, EaterExceptionLocated;

    public int getCurrentPosition() {
        return this.i;
    }

    protected final String eatAllToEnd() throws EaterException {
        String result = this.s.substring(this.i);
        this.i = this.s.length();
        return result;
    }

    public final TValue eatExpression(TContext context, TMemory memory) throws EaterException, EaterExceptionLocated {
        char ch = this.peekChar();
        if (ch == '{' || ch == '[') {
            String data = this.eatAllToEnd();
            JsonValue json = Json.parse(data);
            return TValue.fromJson(json);
        }
        TokenStack tokenStack = this.eatTokenStack();
        return tokenStack.getResult(this.getLineLocation(), context, memory);
    }

    protected final TokenStack eatTokenStack() throws EaterException {
        TokenStack tokenStack = new TokenStack();
        this.addIntoTokenStack(tokenStack, false);
        if (tokenStack.size() == 0) {
            throw EaterException.located("Missing expression");
        }
        return tokenStack;
    }

    protected final TValue eatExpressionStopAtColon(TContext context, TMemory memory) throws EaterException, EaterExceptionLocated {
        TokenStack tokenStack = new TokenStack();
        this.addIntoTokenStack(tokenStack, true);
        return tokenStack.getResult(this.getLineLocation(), context, memory);
    }

    protected final void addIntoTokenStack(TokenStack tokenStack, boolean stopAtColon) throws EaterException {
        Token lastToken = null;
        Token token;
        while ((token = TokenType.eatOneToken(lastToken, this, stopAtColon)) != null) {
            tokenStack.add(token);
            if (token.getTokenType() == TokenType.SPACES) continue;
            lastToken = token;
        }
        return;
    }

    public final String eatAndGetQuotedString() throws EaterException {
        char separator = this.peekChar();
        if (!TLineType.isQuote(separator)) {
            throw EaterException.located("quote10");
        }
        this.checkAndEatChar(separator);
        StringBuilder value = new StringBuilder();
        this.addUpTo(separator, value);
        this.checkAndEatChar(separator);
        return value.toString();
    }

    protected final String eatAndGetOptionalQuotedString() throws EaterException {
        char quote = this.peekChar();
        if (TLineType.isQuote(quote)) {
            return this.eatAndGetQuotedString();
        }
        StringBuilder value = new StringBuilder();
        int level = 0;
        while (true) {
            char ch;
            if ((ch = this.peekChar()) == '\u0000') {
                throw EaterException.located("until001");
            }
            if (level == 0 && (ch == ',' || ch == ')')) {
                return value.toString().trim();
            }
            ch = this.eatOneChar();
            if (ch == '(') {
                ++level;
            } else if (ch == ')') {
                --level;
            }
            value.append(ch);
        }
    }

    public final String eatAndGetNumber() throws EaterException {
        StringBuilder result = new StringBuilder();
        while (true) {
            char ch = this.peekChar();
            if (result.length() == 0 && ch == '-') {
                result.append(this.eatOneChar());
                continue;
            }
            if (ch == '\u0000' || !TLineType.isLatinDigit(ch)) {
                return result.toString();
            }
            result.append(this.eatOneChar());
        }
    }

    public final String eatAndGetSpaces() throws EaterException {
        StringBuilder result = new StringBuilder();
        char ch;
        while ((ch = this.peekChar()) != '\u0000' && TLineType.isSpaceChar(ch)) {
            result.append(this.eatOneChar());
        }
        return result.toString();
    }

    protected final String eatAndGetVarname() throws EaterException {
        StringBuilder varname = new StringBuilder("" + this.eatOneChar());
        if (!TLineType.isLetterOrUnderscoreOrDollar(varname.charAt(0))) {
            throw EaterException.located("a002");
        }
        this.addUpToLastLetterOrUnderscoreOrDigit(varname);
        return varname.toString();
    }

    protected final String eatAndGetFunctionName() throws EaterException {
        StringBuilder varname = new StringBuilder("" + this.eatOneChar());
        if (!TLineType.isLetterOrUnderscoreOrDollar(varname.charAt(0))) {
            throw EaterException.located("a003");
        }
        this.addUpToLastLetterOrUnderscoreOrDigit(varname);
        return varname.toString();
    }

    public final void skipSpaces() {
        while (this.i < this.s.length() && Character.isWhitespace(this.s.charAt(this.i))) {
            ++this.i;
        }
    }

    protected final void skipUntilChar(char ch) {
        while (this.i < this.s.length() && this.s.charAt(this.i) != ch) {
            ++this.i;
        }
    }

    public final char peekChar() {
        if (this.i >= this.s.length()) {
            return '\u0000';
        }
        return this.s.charAt(this.i);
    }

    public final boolean matchAffectation() {
        String tmp = this.s.substring(this.i);
        boolean result = tmp.matches("^\\$?[_\\p{L}][_\\p{L}0-9]*\\s*=.*");
        return result;
    }

    public final char peekCharN2() {
        if (this.i + 1 >= this.s.length()) {
            return '\u0000';
        }
        return this.s.charAt(this.i + 1);
    }

    protected final boolean hasNextChar() {
        return this.i < this.s.length();
    }

    public final char eatOneChar() {
        char ch = this.s.charAt(this.i);
        ++this.i;
        return ch;
    }

    protected final void checkAndEatChar(char ch) throws EaterException {
        if (this.i >= this.s.length() || this.s.charAt(this.i) != ch) {
            throw EaterException.located("a001");
        }
        ++this.i;
    }

    protected final boolean safeCheckAndEatChar(char ch) throws EaterException {
        if (this.i >= this.s.length() || this.s.charAt(this.i) != ch) {
            return false;
        }
        ++this.i;
        return true;
    }

    protected final void optionallyEatChar(char ch) throws EaterException {
        if (this.i >= this.s.length() || this.s.charAt(this.i) != ch) {
            return;
        }
        assert (this.s.charAt(this.i) == ch);
        ++this.i;
    }

    protected final void checkAndEatChar(String s) throws EaterException {
        for (int j = 0; j < s.length(); ++j) {
            this.checkAndEatChar(s.charAt(j));
        }
    }

    protected final void addUpToLastLetterOrUnderscoreOrDigit(StringBuilder sb) {
        while (this.i < this.s.length()) {
            char ch = this.s.charAt(this.i);
            if (!TLineType.isLetterOrUnderscoreOrDigit(ch)) {
                return;
            }
            ++this.i;
            sb.append(ch);
        }
    }

    protected final void addUpTo(char separator, StringBuilder sb) {
        while (this.i < this.s.length()) {
            char ch = this.peekChar();
            if (ch == separator) {
                return;
            }
            ++this.i;
            sb.append(ch);
        }
    }

    protected final TFunctionImpl eatDeclareFunction(TContext context, TMemory memory, boolean unquoted, LineLocation location, boolean allowNoParenthesis, TFunctionType type) throws EaterException, EaterExceptionLocated {
        char ch;
        ArrayList<TFunctionArgument> args = new ArrayList<TFunctionArgument>();
        String functionName = this.eatAndGetFunctionName();
        this.skipSpaces();
        if (!this.safeCheckAndEatChar('(')) {
            if (allowNoParenthesis) {
                return new TFunctionImpl(functionName, args, unquoted, type);
            }
            throw EaterException.located("Missing opening parenthesis");
        }
        while (true) {
            this.skipSpaces();
            ch = this.peekChar();
            if (TLineType.isLetterOrUnderscoreOrDollar(ch)) {
                TValue defValue;
                String varname = this.eatAndGetVarname();
                this.skipSpaces();
                if (this.peekChar() == '=') {
                    this.eatOneChar();
                    TokenStack def = TokenStack.eatUntilCloseParenthesisOrComma(this);
                    def.guessFunctions();
                    defValue = def.getResult(this.getLineLocation(), context, memory);
                } else {
                    defValue = null;
                }
                args.add(new TFunctionArgument(varname, defValue));
                continue;
            }
            if (ch != ',') break;
            this.checkAndEatChar(',');
        }
        if (ch != ')') {
            throw EaterException.located("Error in function definition");
        }
        this.checkAndEatChar(")");
        this.skipSpaces();
        return new TFunctionImpl(functionName, args, unquoted, type);
    }

    protected final TFunctionImpl eatDeclareReturnFunctionWithOptionalReturn(TContext context, TMemory memory, boolean unquoted, LineLocation location) throws EaterException, EaterExceptionLocated {
        TFunctionImpl result = this.eatDeclareFunction(context, memory, unquoted, location, false, TFunctionType.RETURN_FUNCTION);
        if (this.peekChar() == 'r') {
            this.checkAndEatChar("return");
            this.skipSpaces();
            String line = "!return " + this.eatAllToEnd();
            result.addBody(new StringLocated(line, location));
        } else if (this.peekChar() == '!') {
            this.checkAndEatChar("!return");
            this.skipSpaces();
            String line = "!return " + this.eatAllToEnd();
            result.addBody(new StringLocated(line, location));
        }
        return result;
    }

    protected final TFunctionImpl eatDeclareProcedure(TContext context, TMemory memory, boolean unquoted, LineLocation location) throws EaterException, EaterExceptionLocated {
        TFunctionImpl result = this.eatDeclareFunction(context, memory, unquoted, location, false, TFunctionType.PROCEDURE);
        return result;
    }
}

