/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.soap;

import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDCredentials;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.MalformedLSIDException;
import com.ibm.lsid.server.AuthenticationResponse;
import com.ibm.lsid.server.LSIDAuthenticationException;
import com.ibm.lsid.server.LSIDRequestContext;
import com.ibm.lsid.server.LSIDSecurityService;
import com.ibm.lsid.server.conf.ServiceConfigurationConstants;
import com.ibm.lsid.server.conf.ServiceRegistry;
import com.ibm.lsid.server.soap.AxisFaultBuilder;
import com.ibm.lsid.server.soap.InputStreamDataSource;
import com.ibm.lsid.server.soap.WebserviceConstants;
import com.ibm.lsid.soap.SOAPConstants;
import com.ibm.lsid.soap.SOAPUtils;
import com.ibm.lsid.wsdl.WSDLConstants;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.transport.http.HTTPConstants;

public class LSIDWebService
implements ServiceConfigurationConstants,
WebserviceConstants,
WSDLConstants,
SOAPConstants {
    protected LSIDRequestContext getRequestContext(LSID lsid) throws AxisFault {
        int lastSlash;
        MessageContext msgctx = AxisEngine.getCurrentMessageContext();
        LSIDRequestContext ctx = new LSIDRequestContext();
        msgctx.setProperty("lsidrequestctx", (Object)ctx);
        ctx.setLsid(lsid);
        SOAPEnvelope env = msgctx.getRequestMessage().getSOAPEnvelope();
        Vector headers = env.getHeaders();
        int i = 0;
        while (i < headers.size()) {
            SOAPHeaderElement elt = (SOAPHeaderElement)headers.elementAt(i);
            String headerName = elt.getName();
            String value = elt.getValue();
            ctx.addProtocolHeader(headerName, value);
            ++i;
        }
        LSIDCredentials creds = new LSIDCredentials();
        if (msgctx.getUsername() != null && msgctx.getPassword() != null) {
            creds.setProperty("basicUsername", (Object)msgctx.getUsername());
            creds.setProperty("basicPassword", (Object)msgctx.getPassword());
        }
        ctx.setCredentials(creds);
        HttpServletRequest servletReq = (HttpServletRequest)msgctx.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        ctx.setReqUrl(servletReq.getRequestURL().toString());
        String pathinfo = servletReq.getPathInfo();
        if (pathinfo != null && (lastSlash = pathinfo.lastIndexOf(47)) != -1) {
            ctx.setHint(pathinfo.substring(lastSlash + 1));
        }
        HttpServlet servlet = (HttpServlet)msgctx.getProperty(HTTPConstants.MC_HTTP_SERVLET);
        ServletContext servletCtx = servlet.getServletContext();
        ServiceRegistry reg = (ServiceRegistry)servletCtx.getAttribute("authenticationServiceRegistry");
        AuthenticationResponse authresp = null;
        LSIDSecurityService service = (LSIDSecurityService)reg.lookupService(lsid);
        if (service != null) {
            try {
                authresp = service.authenticate(ctx);
            }
            catch (LSIDAuthenticationException e) {
                throw AxisFaultBuilder.createFault(e);
            }
        }
        if (authresp != null && !authresp.isSuccess()) {
            ctx.setAuthResponse(authresp);
            throw AxisFaultBuilder.createFault(authresp);
        }
        ctx.setAuthResponse(authresp);
        return ctx;
    }

    protected ServiceRegistry getServiceRegistry(String type) {
        MessageContext msgctx = AxisEngine.getCurrentMessageContext();
        HttpServlet servlet = (HttpServlet)msgctx.getProperty(HTTPConstants.MC_HTTP_SERVLET);
        ServletContext servletCtx = servlet.getServletContext();
        ServiceRegistry reg = (ServiceRegistry)servletCtx.getAttribute(type);
        return reg;
    }

    protected void addResponseHeader(String name, String value) throws AxisFault {
        try {
            MessageContext msgctx = AxisEngine.getCurrentMessageContext();
            SOAPEnvelope env = msgctx.getResponseMessage().getSOAPEnvelope();
            SOAPHeaderElement header = new SOAPHeaderElement((Name)new PrefixedQName(null, name, null));
            header.addTextNode(value);
            env.addHeader(header);
        }
        catch (SOAPException e) {
            e.printStackTrace();
            throw AxisFaultBuilder.createFault((Exception)((Object)e), "Error adding response header");
        }
    }

    protected void addExpirationHeader(Date expires) throws AxisFault {
        this.addResponseHeader("expires", SOAPUtils.writeDate((Date)expires));
    }

    protected LSID getLSID(SOAPBodyElement bodyElt) throws AxisFault {
        try {
            Iterator it = bodyElt.getChildElements((Name)new PrefixedQName(null, "lsid", null));
            if (!it.hasNext()) {
                throw AxisFaultBuilder.createFault(712, "Must specify LSID parameter");
            }
            MessageElement elt = (MessageElement)it.next();
            return new LSID(elt.getValue());
        }
        catch (MalformedLSIDException e) {
            throw AxisFaultBuilder.createFault((LSIDException)((Object)e));
        }
    }

    protected String getStringValue(SOAPBodyElement bodyElt, String partname) throws AxisFault {
        Iterator it = bodyElt.getChildElements((Name)new PrefixedQName(null, partname, null));
        if (!it.hasNext()) {
            throw AxisFaultBuilder.createFault(712, "Must specify " + partname);
        }
        MessageElement elt = (MessageElement)it.next();
        return elt.getValue();
    }

    protected void addStringValue(SOAPBodyElement bodyElt, String partname, String value) throws AxisFault {
        try {
            MessageElement elt = new MessageElement();
            elt.setName(partname);
            elt.addTextNode(value);
            bodyElt.addChildElement((SOAPElement)elt);
        }
        catch (SOAPException e) {
            throw AxisFaultBuilder.createFault((Exception)((Object)e), "error building response");
        }
    }

    protected void addAttachment(InputStream data) {
        MessageContext msgctx = AxisEngine.getCurrentMessageContext();
        Message rspmsg = msgctx.getResponseMessage();
        rspmsg.getAttachmentsImpl().setSendType(2);
        AttachmentPart attachmentPart = new AttachmentPart(new DataHandler((DataSource)new InputStreamDataSource(data, "data", "application/octet-stream")));
        rspmsg.addAttachmentPart((javax.xml.soap.AttachmentPart)attachmentPart);
    }

    protected void writeCurrentMessage() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            MessageContext.getCurrentContext().getCurrentMessage().writeTo((OutputStream)out);
            System.err.println(new String(out.toByteArray()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

