/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.impl;

import com.ibm.lsid.ExpiringResponse;
import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDCredentials;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.MalformedLSIDException;
import com.ibm.lsid.MetadataResponse;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.client.LSIDResolver;
import com.ibm.lsid.server.LSIDAuthorityService;
import com.ibm.lsid.server.LSIDDataService;
import com.ibm.lsid.server.LSIDMetadataService;
import com.ibm.lsid.server.LSIDRequestContext;
import com.ibm.lsid.server.LSIDServerException;
import com.ibm.lsid.server.LSIDServiceConfig;
import com.ibm.lsid.wsdl.HTTPLocation;
import com.ibm.lsid.wsdl.LSIDDataPort;
import com.ibm.lsid.wsdl.LSIDMetadataPort;
import com.ibm.lsid.wsdl.LSIDWSDLWrapper;
import com.ibm.lsid.wsdl.SOAPLocation;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class CachingProxyAuthority
implements LSIDAuthorityService,
LSIDMetadataService,
LSIDDataService {
    private static final String PROXY_HOME = "proxyHome";
    private static Hashtable resolverPool = new Hashtable();
    LSIDServiceConfig config;

    public ExpiringResponse getAvailableServices(LSIDRequestContext req) throws LSIDServerException {
        LSID lsid = req.getLsid();
        String reqUrl = req.getReqUrl();
        try {
            LSIDWSDLWrapper wsdl = new LSIDWSDLWrapper(lsid);
            boolean usecache = !req.getProtocalHeaders().containsValue("no-cache");
            LSIDResolver resolver = CachingProxyAuthority.getResolver(lsid, usecache);
            LSIDWSDLWrapper wrapper = resolver.getWSDLWrapper();
            LSIDDataPort dataPort = wrapper.getDataPort();
            if (dataPort != null) {
                String dataUrl = reqUrl.substring(0, reqUrl.lastIndexOf(47)) + "/data";
                wsdl.setDataLocation((LSIDDataPort)new SOAPLocation("CachingProxySOAP", "SOAPData", dataUrl));
                dataUrl = reqUrl.substring(0, reqUrl.lastIndexOf(47)) + "/data";
                try {
                    URL dataURL = new URL(dataUrl);
                    wsdl.setDataLocation((LSIDDataPort)new HTTPLocation("CachingProxyHTTP", "HTTPData", dataURL.getHost(), dataURL.getPort(), dataURL.getPath()));
                }
                catch (MalformedURLException e) {
                    throw new LSIDServerException(e, "Internal error parsing URL: " + dataUrl);
                }
            }
            Enumeration portNames = wrapper.getMetadataPortNames();
            int portNum = 1;
            while (portNames.hasMoreElements()) {
                LSIDMetadataPort metaDataPort = wrapper.getMetadataPort((String)portNames.nextElement());
                if (metaDataPort != null) {
                    String metaDataUrl = reqUrl.substring(0, reqUrl.lastIndexOf(47)) + "/metadata/" + metaDataPort.getServiceName() + ";" + metaDataPort.getName();
                    wsdl.setMetadataLocation((LSIDMetadataPort)new SOAPLocation("CachingProxySOAP", "SOAPMetaData" + portNum, metaDataUrl));
                    metaDataUrl = reqUrl.substring(0, reqUrl.lastIndexOf(47)) + "/metadata";
                    try {
                        URL dataURL = new URL(metaDataUrl);
                        wsdl.setMetadataLocation((LSIDMetadataPort)new HTTPLocation("CachingProxyHTTP", "HTTPMetaData" + portNum, dataURL.getHost(), dataURL.getPort(), dataURL.getPath() + "?hint=" + metaDataPort.getServiceName() + ";" + metaDataPort.getName()));
                    }
                    catch (MalformedURLException e) {
                        throw new LSIDServerException(e, "Internal error parsing URL: " + metaDataUrl);
                    }
                }
                ++portNum;
            }
            this.addCustomServices(req, wsdl);
            return new ExpiringResponse((Object)wsdl.getWSDL(), wrapper.getExpiration());
        }
        catch (LSIDException e) {
            throw new LSIDServerException((Exception)((Object)e), e.getErrorCode(), "Proxy Error in getAvailableOperations(" + lsid + "): " + e.getDescription());
        }
    }

    public MetadataResponse getMetadata(LSIDRequestContext req, String[] formats) throws LSIDServerException {
        LSID lsid = req.getLsid();
        String hint = req.getHint();
        try {
            LSIDMetadataPort port = this.useAlternateMetadataPort(req, formats);
            if (hint == null) {
                throw new LSIDServerException("No hint specified in meta data service");
            }
            boolean usecache = !req.getProtocalHeaders().containsValue("no-cache");
            LSIDResolver resolver = CachingProxyAuthority.getResolver(lsid, usecache);
            if (port == null) {
                hint = hint.replace(';', ':');
                port = resolver.getWSDLWrapper().getMetadataPort(hint);
            }
            return resolver.getMetadata(port, formats);
        }
        catch (LSIDException e) {
            throw new LSIDServerException((Exception)((Object)e), e.getErrorCode(), "Proxy Error retrieving meta data for " + lsid + " | " + e.getDescription());
        }
    }

    public InputStream getData(LSIDRequestContext req) throws LSIDServerException {
        LSID lsid = req.getLsid();
        try {
            boolean usecache = !req.getProtocalHeaders().containsValue("no-cache");
            LSIDResolver resolver = CachingProxyAuthority.getResolver(lsid, usecache);
            return resolver.getData();
        }
        catch (LSIDException e) {
            throw new LSIDServerException((Exception)((Object)e), e.getErrorCode(), "Proxy Error retrieving data for " + lsid + " | " + e.getDescription());
        }
    }

    public InputStream getDataByRange(LSIDRequestContext req, int start, int length) throws LSIDServerException {
        LSID lsid = req.getLsid();
        try {
            boolean usecache = !req.getProtocalHeaders().containsValue("no-cache");
            LSIDResolver resolver = CachingProxyAuthority.getResolver(lsid, usecache);
            return resolver.getData(start, length);
        }
        catch (LSIDException e) {
            throw new LSIDServerException((Exception)((Object)e), e.getErrorCode(), "Proxy Error retrieving data for " + lsid + " | " + e.getDescription());
        }
    }

    public void initService(LSIDServiceConfig config) throws LSIDServerException {
        this.config = config;
    }

    protected void addCustomServices(LSIDRequestContext ctx, LSIDWSDLWrapper wrapper) throws LSIDServerException {
    }

    protected LSIDMetadataPort useAlternateMetadataPort(LSIDRequestContext ctx, String[] formats) throws LSIDServerException {
        return null;
    }

    private static synchronized LSIDResolver getResolver(LSID lsid, boolean usecache) throws LSIDException {
        LSIDResolver resolver = new LSIDResolver(lsid);
        resolver.setUseLocalCache(usecache);
        return resolver;
    }

    public void notifyForeignAuthority(LSIDRequestContext req, LSIDAuthority authorityName) throws LSIDServerException {
        try {
            LSIDResolver.notifyForeignAuthority((LSIDAuthority)authorityName, (LSID)req.getLsid(), (LSIDCredentials)req.getCredentials());
        }
        catch (MalformedLSIDException e) {
            throw new LSIDServerException((Exception)((Object)e), 200, "Malformed LSID");
        }
        catch (LSIDException e) {
            throw new LSIDServerException((Exception)((Object)e), 500, "Error");
        }
    }

    public void revokeNotificationForeignAuthority(LSIDRequestContext req, LSIDAuthority authorityName) throws LSIDServerException {
        try {
            LSIDResolver.revokeNotificationForeignAuthority((LSIDAuthority)authorityName, (LSID)req.getLsid(), (LSIDCredentials)req.getCredentials());
        }
        catch (MalformedLSIDException e) {
            throw new LSIDServerException((Exception)((Object)e), 200, "Malformed LSID");
        }
        catch (LSIDException e) {
            throw new LSIDServerException((Exception)((Object)e), 500, "Error");
        }
    }
}

