/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.conf;

import com.ibm.lsid.LSID;
import com.ibm.lsid.server.LSIDService;
import com.ibm.lsid.server.LSIDServiceConfig;
import com.ibm.lsid.server.conf.ASDLComponentHandler;
import com.ibm.lsid.server.conf.CachingComponentHandler;
import com.ibm.lsid.server.conf.LSIDConfigurationException;
import com.ibm.lsid.server.conf.LSIDServiceComponentHandler;
import com.ibm.lsid.server.conf.MSDLComponentHandler;
import com.ibm.lsid.server.conf.ServiceComponentHandler;
import com.ibm.lsid.server.conf.ServiceConfigurationConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ServiceRegistry
implements ServiceConfigurationConstants {
    private static final String SERVICE = "services";
    private Hashtable defaultHandlers = new Hashtable();
    private Hashtable handlers = new Hashtable();
    private Hashtable maps = new Hashtable();
    private Hashtable serviceConfigs = new Hashtable();
    private Vector instances = new Vector();
    private Hashtable registry = new Hashtable();
    Element envNS = null;

    public static ServiceRegistry getAuthorityServiceRegistry(File location) throws LSIDConfigurationException {
        ServiceRegistry reg = new ServiceRegistry();
        reg.setComponentHandler("asdl", new ASDLComponentHandler());
        reg.setComponentHandler("caching", new CachingComponentHandler());
        reg.load(location, new String[]{"auth"});
        return reg;
    }

    public static ServiceRegistry getMetaDataServiceRegistry(File location) throws LSIDConfigurationException {
        ServiceRegistry reg = new ServiceRegistry();
        reg.setComponentHandler("msdl", new MSDLComponentHandler());
        reg.setComponentHandler("caching", new CachingComponentHandler());
        reg.load(location, new String[]{"meta"});
        return reg;
    }

    public static ServiceRegistry getDataServiceRegistry(File location) throws LSIDConfigurationException {
        ServiceRegistry reg = new ServiceRegistry();
        reg.setComponentHandler("caching", new CachingComponentHandler());
        reg.load(location, new String[]{"data"});
        return reg;
    }

    public static ServiceRegistry getAuthenticationServiceRegistry(File location) throws LSIDConfigurationException {
        ServiceRegistry reg = new ServiceRegistry();
        reg.load(location, new String[]{"authentication"});
        return reg;
    }

    public static ServiceRegistry getAssigningServiceRegistry(File location) throws LSIDConfigurationException {
        ServiceRegistry reg = new ServiceRegistry();
        reg.load(location, new String[]{"assn"});
        return reg;
    }

    public ServiceRegistry() throws LSIDConfigurationException {
        try {
            this.setComponentHandler("class", new LSIDServiceComponentHandler());
        }
        catch (Exception e) {
            throw new LSIDConfigurationException(e, "Error reading service mappings");
        }
    }

    public LSIDService lookupService(LSID lsid) {
        Pattern lookup = new Pattern(lsid.getAuthority().toString(), lsid.getNamespace());
        LSIDService service = (LSIDService)this.registry.get(lookup.toString());
        if (service != null) {
            return service;
        }
        lookup.ns = "*";
        service = (LSIDService)this.registry.get(lookup.toString());
        if (service != null) {
            return service;
        }
        lookup.ns = lsid.getNamespace();
        lookup.auth = "*";
        service = (LSIDService)this.registry.get(lookup.toString());
        if (service != null) {
            return service;
        }
        lookup.ns = "*";
        service = (LSIDService)this.registry.get(lookup.toString());
        if (service != null) {
            return service;
        }
        return null;
    }

    public Vector getAllServices() {
        return this.instances;
    }

    public synchronized void load(File location, String[] components) throws LSIDConfigurationException {
        if (location != null) {
            if (!location.isDirectory()) {
                throw new LSIDConfigurationException("Directory " + location + " does not exist");
            }
        } else {
            location = new File(SERVICE);
        }
        File[] files = location.listFiles();
        int i = 0;
        while (i < files.length) {
            if (!files[i].isDirectory() && files[i].toString().endsWith(".xml")) {
                try {
                    String comps = "";
                    int j = 0;
                    while (j < components.length) {
                        comps = comps + components[j] + " ";
                        ++j;
                    }
                    System.err.println("Loading " + comps + "components from " + files[i]);
                    this.loadSingle(files[i], components);
                }
                catch (Exception e) {
                    System.err.println("LSID config file: " + files[i] + " could not be loaded");
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public synchronized void loadSingle(File file, String[] components) throws LSIDConfigurationException {
        try {
            this.handlers.clear();
            this.maps.clear();
            this.serviceConfigs.clear();
            FileInputStream in = new FileInputStream(file);
            InputSource src = new InputSource(in);
            DOMParser parser = new DOMParser();
            parser.parse(src);
            Document doc = parser.getDocument();
            Node root = doc.getFirstChild();
            while (!(root instanceof Element)) {
                root = root.getNextSibling();
            }
            Element rootelt = (Element)root;
            this.envNS = doc.createElement("nsmappings");
            this.envNS.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:rsdl", "http://www.ibm.com/LSID/Standard/rsdl");
            this.loadComponentHandlers(rootelt);
            this.loadMaps(rootelt);
            int i = 0;
            while (i < components.length) {
                this.loadComponents(rootelt, components[i]);
                ++i;
            }
        }
        catch (IOException e) {
            throw new LSIDConfigurationException(e, "");
        }
        catch (SAXException e) {
            throw new LSIDConfigurationException(e, "");
        }
    }

    private void setComponentHandler(String type, ServiceComponentHandler handler) {
        this.defaultHandlers.put(type, handler);
    }

    private void loadComponentHandlers(Element root) throws LSIDConfigurationException {
        try {
            String xpathStr = "rsdl:component-handlers/rsdl:component-handler";
            NodeList handlers = XPathAPI.selectNodeList((Node)root, (String)xpathStr, (Node)this.envNS);
            if (handlers != null) {
                int i = 0;
                while (i < handlers.getLength()) {
                    Element handler = (Element)handlers.item(i);
                    String typeName = handler.getAttribute("type");
                    String className = handler.getAttribute("classname");
                    ServiceComponentHandler sch = (ServiceComponentHandler)Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
                    this.handlers.put(typeName, sch);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new LSIDConfigurationException(e, "Error loading component handlers");
        }
    }

    private void loadMaps(Element root) throws LSIDConfigurationException {
        try {
            String xpathStr = "rsdl:maps/rsdl:map";
            NodeList maps = XPathAPI.selectNodeList((Node)root, (String)xpathStr, (Node)this.envNS);
            if (maps != null) {
                int i = 0;
                while (i < maps.getLength()) {
                    Element map = (Element)maps.item(i);
                    String name = map.getAttribute("name");
                    xpathStr = "rsdl:pattern";
                    NodeList patterns = XPathAPI.selectNodeList((Node)map, (String)xpathStr, (Node)this.envNS);
                    if (patterns != null) {
                        Pattern[] pats = new Pattern[patterns.getLength()];
                        int j = 0;
                        while (j < patterns.getLength()) {
                            Element pattern = (Element)patterns.item(j);
                            pats[j] = new Pattern(pattern.getAttribute("auth"), pattern.getAttribute("ns"));
                            ++j;
                        }
                        this.maps.put(name, pats);
                    }
                    ++i;
                }
            }
        }
        catch (TransformerException e) {
            throw new LSIDConfigurationException(e, "Error loading maps");
        }
    }

    private void loadComponents(Element root, String component) throws LSIDConfigurationException {
        try {
            String xpathStr = "rsdl:services/rsdl:service/rsdl:components/rsdl:" + component;
            NodeList components = XPathAPI.selectNodeList((Node)root, (String)xpathStr, (Node)this.envNS);
            if (components != null) {
                int i = 0;
                while (i < components.getLength()) {
                    Element comp = (Element)components.item(i);
                    String mapName = comp.getAttribute("map");
                    Pattern[] map = null;
                    map = mapName == null || mapName.equals("") ? new Pattern[]{new Pattern("*", "*")} : (Pattern[])this.maps.get(mapName);
                    if (map == null) {
                        throw new LSIDConfigurationException("Bad map link: " + mapName);
                    }
                    String typeName = comp.getAttribute("type");
                    ServiceComponentHandler handler = (ServiceComponentHandler)this.handlers.get(typeName);
                    if (handler == null) {
                        handler = (ServiceComponentHandler)this.defaultHandlers.get(typeName);
                    }
                    if (handler == null) {
                        throw new LSIDConfigurationException("No handler for service component type " + typeName);
                    }
                    if (!handler.knownServices().contains(component)) {
                        throw new LSIDConfigurationException("Handler not valid for this component (" + component + ") and type (" + typeName + ") combination");
                    }
                    LSIDServiceConfig config = this.getServiceConfig(comp);
                    LSIDService service = handler.loadComponent(comp, config);
                    if (service == null) {
                        throw new LSIDConfigurationException("Handler could not load service for comp " + typeName);
                    }
                    int j = 0;
                    while (j < map.length) {
                        this.registry.put(map[j].toString(), service);
                        ++j;
                    }
                    this.instances.addElement(service);
                    ++i;
                }
            }
        }
        catch (TransformerException e) {
            throw new LSIDConfigurationException(e, "Error loading " + component + " components");
        }
    }

    private LSIDServiceConfig getServiceConfig(Element comp) throws LSIDConfigurationException {
        try {
            Element service = (Element)comp.getParentNode().getParentNode();
            String serviceName = service.getAttribute("name");
            LSIDServiceConfigImpl config = (LSIDServiceConfigImpl)this.serviceConfigs.get(serviceName);
            if (config != null) {
                return config;
            }
            config = new LSIDServiceConfigImpl();
            String xpathStr = "rsdl:params/rsdl:param";
            NodeList params = XPathAPI.selectNodeList((Node)service, (String)xpathStr, (Node)this.envNS);
            if (params != null) {
                int i = 0;
                while (i < params.getLength()) {
                    Element param = (Element)params.item(i);
                    String name = param.getAttribute("name");
                    xpathStr = "child::text()";
                    String value = XPathAPI.selectSingleNode((Node)param, (String)xpathStr, (Node)this.envNS).getNodeValue();
                    config.setProperty(name, value);
                    ++i;
                }
            }
            this.serviceConfigs.put(serviceName, config);
            return config;
        }
        catch (TransformerException e) {
            throw new LSIDConfigurationException(e, "Error loading service config, init params");
        }
    }

    private class LSIDServiceConfigImpl
    implements LSIDServiceConfig {
        private Hashtable props = new Hashtable();

        private LSIDServiceConfigImpl() {
        }

        public Enumeration getPropertyNames() {
            return this.props.keys();
        }

        public String getProperty(String property) {
            return (String)this.props.get(property);
        }

        private void setProperty(String property, String value) {
            this.props.put(property, value);
        }
    }

    private class Pattern {
        private String auth;
        private String ns;

        Pattern(String auth, String ns) {
            this.auth = auth.toLowerCase();
            this.ns = ns.toLowerCase();
        }

        public String toString() {
            return this.auth + ":" + this.ns;
        }
    }
}

