/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.conf;

import com.ibm.lsid.server.LSIDService;
import com.ibm.lsid.server.LSIDServiceConfig;
import com.ibm.lsid.server.conf.LSIDConfigurationException;
import com.ibm.lsid.server.conf.ServiceComponentHandler;
import com.ibm.lsid.server.conf.ServiceConfigurationConstants;
import com.ibm.lsid.server.impl.InlineMetadataService;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MSDLComponentHandler
implements ServiceComponentHandler,
ServiceConfigurationConstants {
    public LSIDService loadComponent(Element compElt, LSIDServiceConfig config) throws LSIDConfigurationException {
        String location = compElt.getAttribute("location");
        if (location == null) {
            throw new LSIDConfigurationException("Must specify location of MSDL document");
        }
        Element envNS = compElt.getOwnerDocument().createElement("nsmappings");
        try {
            InlineMetadataService imds = new InlineMetadataService();
            if (location.equals("file")) {
                String xpathStr = "child::text()";
                String fileStr = XPathAPI.selectSingleNode((Node)compElt, (String)xpathStr, (Node)envNS).getNodeValue();
                imds.load(new File(fileStr));
            } else if (location.equals("url")) {
                String xpathStr = "child::text()";
                String urlStr = XPathAPI.selectSingleNode((Node)compElt, (String)xpathStr, (Node)envNS).getNodeValue();
                imds.load(new URL(urlStr));
            } else if (location.equals("java-resource")) {
                String xpathStr = "child::text()";
                String resStr = XPathAPI.selectSingleNode((Node)compElt, (String)xpathStr, (Node)envNS).getNodeValue();
                InputStream resource = this.getClass().getResourceAsStream(resStr);
                imds.load(resource);
            } else if (location.equals("inline")) {
                envNS.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:msdl", "http://www.ibm.com/LSID/Standard/msdl");
                String xpathStr = "msdl:metadata";
                Element asdlElt = (Element)XPathAPI.selectSingleNode((Node)compElt, (String)xpathStr, (Node)envNS);
                imds.load(asdlElt);
            } else {
                throw new LSIDConfigurationException("Bad MSDL location: " + location);
            }
            return imds;
        }
        catch (Exception e) {
            throw new LSIDConfigurationException(e, "Error handling MSDL component");
        }
    }

    public Vector knownServices() {
        Vector<String> v = new Vector<String>(1);
        v.add("meta");
        return v;
    }
}

