/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

public class JType {
    public static final JType Boolean = new JType("boolean");
    public static final JType Byte = new JType("byte");
    public static final JType Char = new JType("char");
    public static final JType Double = new JType("double");
    public static final JType Float = new JType("float");
    public static final JType Int = new JType("int");
    public static final JType Long = new JType("long");
    public static final JType Short = new JType("short");
    private String name = null;
    private boolean _isArray = false;
    private JType _componentType = null;

    protected JType(String name) {
        this.name = name;
    }

    public final JType createArray() {
        JType jType = new JType(this.getName());
        jType._isArray = true;
        jType._componentType = this;
        return jType;
    }

    public JType getComponentType() {
        return this._componentType;
    }

    public String getLocalName() {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        int idx = name.lastIndexOf(46);
        if (idx >= 0) {
            name = name.substring(idx + 1);
        }
        return name;
    }

    public String getName() {
        return this.name;
    }

    public final boolean isArray() {
        return this._isArray;
    }

    public boolean isPrimitive() {
        return this == Boolean || this == Byte || this == Char || this == Double || this == Float || this == Int || this == Long || this == Short;
    }

    public String toString() {
        if (this._isArray) {
            return this._componentType.toString() + "[]";
        }
        return this.name;
    }

    protected void changePackage(String newPackage) {
        if (this.name == null) {
            return;
        }
        if (this.isPrimitive()) {
            return;
        }
        String localName = null;
        int idx = this.name.lastIndexOf(46);
        localName = idx >= 0 ? this.name.substring(idx + 1) : this.name;
        this.name = newPackage == null || newPackage.length() == 0 ? localName : newPackage + "." + localName;
    }
}

