/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.oql;

import java.util.Hashtable;
import org.exolab.castor.jdo.oql.InvalidCharException;
import org.exolab.castor.jdo.oql.NoMoreTokensException;
import org.exolab.castor.jdo.oql.Token;
import org.exolab.castor.jdo.oql.TokenTypes;

public class Lexer
implements TokenTypes {
    String _queryString;
    int _pos;
    Hashtable keywords;
    boolean endOfQueryPassed = false;

    public Lexer(String oqlQueryString) {
        this._queryString = oqlQueryString;
        this.keywords = new Hashtable();
        this.keywords.put("select", new Integer(1));
        this.keywords.put("as", new Integer(3));
        this.keywords.put("from", new Integer(5));
        this.keywords.put("in", new Integer(6));
        this.keywords.put("where", new Integer(7));
        this.keywords.put("or", new Integer(8));
        this.keywords.put("and", new Integer(9));
        this.keywords.put("like", new Integer(12));
        this.keywords.put("mod", new Integer(22));
        this.keywords.put("abs", new Integer(23));
        this.keywords.put("not", new Integer(24));
        this.keywords.put("nil", new Integer(28));
        this.keywords.put("undefined", new Integer(29));
        this.keywords.put("between", new Integer(40));
        this.keywords.put("distinct", new Integer(41));
        this.keywords.put("is_defined", new Integer(42));
        this.keywords.put("is_undefined", new Integer(43));
        this.keywords.put("list", new Integer(44));
        this.keywords.put("order", new Integer(46));
        this.keywords.put("by", new Integer(47));
        this.keywords.put("asc", new Integer(48));
        this.keywords.put("desc", new Integer(49));
        this.keywords.put("count", new Integer(50));
        this.keywords.put("sum", new Integer(51));
        this.keywords.put("min", new Integer(52));
        this.keywords.put("max", new Integer(53));
        this.keywords.put("avg", new Integer(54));
        this.keywords.put("limit", new Integer(55));
    }

    public boolean hasMoreTokens() {
        return !this.endOfQueryPassed;
    }

    /*
     * Unable to fully structure code
     */
    public Token nextToken() throws NoMoreTokensException, InvalidCharException {
        try {
            oldChar = this._queryString.charAt(this._pos - 1);
        }
        catch (IndexOutOfBoundsException e) {
            oldChar = '\u0000';
        }
        try {
            curChar = this._queryString.charAt(this._pos);
            if (true) ** GOTO lbl24
        }
        catch (IndexOutOfBoundsException e) {
            if (!this.endOfQueryPassed) {
                this.endOfQueryPassed = true;
                return new Token(0, "");
            }
            throw new NoMoreTokensException();
        }
        do {
            oldChar = curChar;
            ++this._pos;
            try {
                curChar = this._queryString.charAt(this._pos);
            }
            catch (IndexOutOfBoundsException e) {
                if (this.endOfQueryPassed) continue;
                this.endOfQueryPassed = true;
                return new Token(0, "");
            }
lbl24:
            // 3 sources

        } while (this.isWhiteSpace(curChar));
        if (this.isDigit(curChar)) {
            return this.numericLiteral();
        }
        if (this.isLetter(curChar)) {
            return this.identifier(oldChar);
        }
        nextChar = '\u0000';
        try {
            nextChar = this._queryString.charAt(this._pos + 1);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (curChar == '!' && nextChar == '=') {
            this._pos += 2;
            return new Token(11, "!=");
        }
        if (curChar == '>' && nextChar == '=') {
            this._pos += 2;
            return new Token(16, ">=");
        }
        if (curChar == '<' && nextChar == '=') {
            this._pos += 2;
            return new Token(14, "<=");
        }
        if (curChar == '|' && nextChar == '|') {
            this._pos += 2;
            return new Token(19, "||");
        }
        if (curChar == '-' && nextChar == '>') {
            this._pos += 2;
            return new Token(31, "->");
        }
        retToken = null;
        switch (curChar) {
            case '\'': {
                return this.charLiteral();
            }
            case '\"': {
                return this.stringLiteral();
            }
            case ':': {
                retToken = new Token(4, ":");
                break;
            }
            case '=': {
                retToken = new Token(10, "=");
                break;
            }
            case '<': {
                retToken = new Token(13, "<");
                break;
            }
            case '>': {
                retToken = new Token(15, ">");
                break;
            }
            case '+': {
                retToken = new Token(17, "+");
                break;
            }
            case '-': {
                retToken = new Token(18, "-");
                break;
            }
            case '*': {
                retToken = new Token(20, "*");
                break;
            }
            case '/': {
                retToken = new Token(21, "/");
                break;
            }
            case '(': {
                retToken = new Token(25, "(");
                break;
            }
            case ')': {
                retToken = new Token(26, ")");
                break;
            }
            case '.': {
                retToken = new Token(30, ".");
                break;
            }
            case '$': {
                retToken = new Token(27, "$");
                break;
            }
            case ',': {
                retToken = new Token(45, ",");
            }
        }
        if (retToken == null) {
            throw new InvalidCharException("An invalid character was found in the query at position " + this._pos);
        }
        ++this._pos;
        return retToken;
    }

    private boolean isWhiteSpace(char theChar) {
        switch (theChar) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    private boolean isDigit(char theChar) {
        return Character.isDigit(theChar);
    }

    private boolean isLetter(char theChar) {
        return Character.isLetter(theChar);
    }

    private Token stringLiteral() throws NoMoreTokensException, InvalidCharException {
        char curChar;
        try {
            curChar = this._queryString.charAt(this._pos);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoMoreTokensException();
        }
        if (curChar != '\"') {
            throw new InvalidCharException("stringLiteral() was called when the next character was not a double quote.  Position: " + this._pos);
        }
        StringBuffer sb = new StringBuffer("\"");
        ++this._pos;
        try {
            curChar = this._queryString.charAt(this._pos);
            while (curChar != '\"') {
                sb.append(curChar);
                if (curChar == '\\') {
                    ++this._pos;
                    curChar = this._queryString.charAt(this._pos);
                    sb.append(curChar);
                }
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
            }
            sb.append(curChar);
            ++this._pos;
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidCharException("End of query string reached, but \" expected.");
        }
        return new Token(36, sb.toString());
    }

    private Token charLiteral() throws NoMoreTokensException, InvalidCharException {
        StringBuffer sb;
        block7: {
            char curChar;
            try {
                curChar = this._queryString.charAt(this._pos);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoMoreTokensException();
            }
            if (curChar != '\'') {
                throw new InvalidCharException("charLiteral() was called when the next character was not a double quote.  Position: " + this._pos);
            }
            sb = new StringBuffer("'");
            ++this._pos;
            try {
                curChar = this._queryString.charAt(this._pos);
                sb.append(curChar);
                ++this._pos;
                if (curChar == '\\') {
                    curChar = this._queryString.charAt(this._pos);
                    sb.append(curChar);
                    ++this._pos;
                }
                if ((curChar = this._queryString.charAt(this._pos)) == '\'') {
                    sb.append(curChar);
                    ++this._pos;
                    break block7;
                }
                throw new InvalidCharException("Character literals may only contain a single character or escape sequence.  Position: " + this._pos);
            }
            catch (IndexOutOfBoundsException e) {
                throw new InvalidCharException("End of query string reached, but ' expected.");
            }
        }
        return new Token(35, sb.toString());
    }

    private char getChar() {
        try {
            return this._queryString.charAt(this._pos);
        }
        catch (IndexOutOfBoundsException e) {
            return '\u0000';
        }
    }

    /*
     * Unable to fully structure code
     */
    private Token numericLiteral() throws NoMoreTokensException, InvalidCharException {
        block10: {
            try {
                curChar = this._queryString.charAt(this._pos);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoMoreTokensException();
            }
            if (!this.isDigit(curChar)) {
                throw new InvalidCharException("numericLiteral() was called when the next character was not a digit.  Position: " + this._pos);
            }
            sb = new StringBuffer().append(curChar);
            ++this._pos;
            curChar = this.getChar();
            while (this.isDigit(curChar)) {
                sb.append(curChar);
                ++this._pos;
                curChar = this.getChar();
            }
            if (curChar != '.') break block10;
            sb.append('.');
            ++this._pos;
            curChar = this.getChar();
            if (this.isDigit(curChar)) ** GOTO lbl28
            throw new InvalidCharException("Digit expected after decimal point in double literal. Position: " + this._pos);
lbl-1000:
            // 1 sources

            {
                sb.append(curChar);
                ++this._pos;
                curChar = this.getChar();
lbl28:
                // 2 sources

                ** while (this.isDigit((char)curChar))
            }
lbl29:
            // 1 sources

            if (curChar == 'E' || curChar == 'e') {
                sb.append(curChar);
                ++this._pos;
                curChar = this.getChar();
                isExponentSigned = false;
                if (curChar == '+' || curChar == '-') {
                    isExponentSigned = true;
                    sb.append(curChar);
                    ++this._pos;
                    curChar = this.getChar();
                }
                if (!this.isDigit(curChar)) {
                    if (isExponentSigned) {
                        throw new InvalidCharException("Digit expected after sign in exponent (double literal).  Position: " + this._pos);
                    }
                    throw new InvalidCharException("Digit expected after exponent character (double literal).  Position: " + this._pos);
                }
                sb.append(curChar);
                ++this._pos;
                curChar = this.getChar();
                while (this.isDigit(curChar)) {
                    sb.append(curChar);
                    ++this._pos;
                    curChar = this.getChar();
                }
            }
            return new Token(34, sb.toString());
        }
        return new Token(33, sb.toString());
    }

    private Token identifier(char oldChar) throws NoMoreTokensException, InvalidCharException {
        char curChar;
        try {
            curChar = this._queryString.charAt(this._pos);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoMoreTokensException();
        }
        if (!this.isLetter(curChar)) {
            throw new InvalidCharException("identifier() was called when the next character was not a letter.  Position: " + this._pos);
        }
        StringBuffer sb = new StringBuffer().append(curChar);
        ++this._pos;
        curChar = this.getChar();
        while (this.isDigit(curChar) || this.isLetter(curChar) || curChar == '_') {
            sb.append(curChar);
            ++this._pos;
            curChar = this.getChar();
        }
        String ident = sb.toString().toLowerCase();
        if (oldChar == '.') {
            return new Token(2, sb.toString());
        }
        if (ident.equals("date")) {
            return this.dateLiteral(sb.toString());
        }
        if (ident.equals("time")) {
            return this.timeLiteral(sb.toString());
        }
        if (ident.equals("timestamp")) {
            return this.timeStampLiteral(sb.toString());
        }
        if (ident.equals("true") || ident.equals("false")) {
            return new Token(32, sb.toString());
        }
        if (this.keywords.containsKey(ident)) {
            return new Token((Integer)this.keywords.get(ident), sb.toString());
        }
        return new Token(2, sb.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Token dateLiteral(String alreadyConsumed) throws InvalidCharException {
        StringBuffer sb = new StringBuffer(alreadyConsumed);
        char curChar = this.getChar();
        try {
            curChar = this._queryString.charAt(this._pos);
            curChar = this.consumeWhiteSpace(curChar);
            if (curChar != '\'') {
                throw new InvalidCharException("The date keyword must be followed by a single quote.  Position: " + this._pos);
            }
            sb.append(" '");
            ++this._pos;
            curChar = this._queryString.charAt(this._pos);
            curChar = this.consumeWhiteSpace(curChar);
            if (!this.isDigit(curChar)) {
                throw new InvalidCharException("Digit expected in date literal.  Position: " + this._pos);
            }
            while (true) {
                if (!this.isDigit(curChar)) {
                    if ((curChar = this.consumeWhiteSpace(curChar)) == '-') break;
                    throw new InvalidCharException("- expected.  Fields in date literal must be separated by a dash.  Position: " + this._pos);
                }
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
            }
            sb.append(curChar);
            ++this._pos;
            curChar = this._queryString.charAt(this._pos);
            curChar = this.consumeWhiteSpace(curChar);
            if (!this.isDigit(curChar)) {
                throw new InvalidCharException("Digit expected in date literal.  Position: " + this._pos);
            }
            while (true) {
                if (!this.isDigit(curChar)) {
                    if ((curChar = this.consumeWhiteSpace(curChar)) == '-') break;
                    throw new InvalidCharException("- expected.  Fields in date literal must be separated by a dash.  Position: " + this._pos);
                }
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
            }
            sb.append(curChar);
            ++this._pos;
            curChar = this._queryString.charAt(this._pos);
            curChar = this.consumeWhiteSpace(curChar);
            if (!this.isDigit(curChar)) {
                throw new InvalidCharException("Digit expected in date literal.  Position: " + this._pos);
            }
            while (true) {
                if (!this.isDigit(curChar)) {
                    if ((curChar = this.consumeWhiteSpace(curChar)) == '\'') break;
                    throw new InvalidCharException("' expected.  Date literal must be enclosed by a single quotes.  Position: " + this._pos);
                }
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
            }
            sb.append(curChar);
            ++this._pos;
            return new Token(37, sb.toString());
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidCharException("End of query encountered in the middle of date literal.");
        }
    }

    /*
     * Unable to fully structure code
     */
    private Token timeLiteral(String alreadyConsumed) throws InvalidCharException {
        sb = new StringBuffer(alreadyConsumed);
        curChar = this.getChar();
        try {
            block10: {
                curChar = this._queryString.charAt(this._pos);
                curChar = this.consumeWhiteSpace(curChar);
                if (curChar != '\'') {
                    throw new InvalidCharException("The time keyword must be followed by a single quote.  Position: " + this._pos);
                }
                sb.append(" '");
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
                curChar = this.consumeWhiteSpace(curChar);
                if (this.isDigit(curChar)) ** GOTO lbl19
                throw new InvalidCharException("Digit expected in time literal.  Position: " + this._pos);
lbl-1000:
                // 1 sources

                {
                    sb.append(curChar);
                    ++this._pos;
                    curChar = this._queryString.charAt(this._pos);
lbl19:
                    // 2 sources

                    ** while (this.isDigit((char)curChar))
                }
lbl20:
                // 1 sources

                if ((curChar = this.consumeWhiteSpace(curChar)) != ':') {
                    throw new InvalidCharException(": expected.  Fields in time literal must be separated by a colon.  Position: " + this._pos);
                }
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
                curChar = this.consumeWhiteSpace(curChar);
                if (this.isDigit(curChar)) ** GOTO lbl33
                throw new InvalidCharException("Digit expected in time literal.  Position: " + this._pos);
lbl-1000:
                // 1 sources

                {
                    sb.append(curChar);
                    ++this._pos;
                    curChar = this._queryString.charAt(this._pos);
lbl33:
                    // 2 sources

                    ** while (this.isDigit((char)curChar))
                }
lbl34:
                // 1 sources

                if ((curChar = this.consumeWhiteSpace(curChar)) != ':') {
                    throw new InvalidCharException(": expected.  Fields in time literal must be separated by a colon.  Position: " + this._pos);
                }
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
                curChar = this.consumeWhiteSpace(curChar);
                if (this.isDigit(curChar)) ** GOTO lbl47
                throw new InvalidCharException("Digit expected in time literal.  Position: " + this._pos);
lbl-1000:
                // 1 sources

                {
                    sb.append(curChar);
                    ++this._pos;
                    curChar = this._queryString.charAt(this._pos);
lbl47:
                    // 2 sources

                    ** while (this.isDigit((char)curChar))
                }
lbl48:
                // 1 sources

                if (curChar != '.') break block10;
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
                if (this.isDigit(curChar)) ** GOTO lbl59
                throw new InvalidCharException("Digit expected in time literal.  Position: " + this._pos);
lbl-1000:
                // 1 sources

                {
                    sb.append(curChar);
                    ++this._pos;
                    curChar = this._queryString.charAt(this._pos);
lbl59:
                    // 2 sources

                    ** while (this.isDigit((char)curChar))
                }
            }
            if ((curChar = this.consumeWhiteSpace(curChar)) != '\'') {
                throw new InvalidCharException("' expected.  Time literal must be enclosed by a single quotes.  Position: " + this._pos);
            }
            sb.append(curChar);
            ++this._pos;
            return new Token(38, sb.toString());
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidCharException("End of query encountered in the middle of time literal.");
        }
    }

    /*
     * Unable to fully structure code
     */
    private Token timeStampLiteral(String alreadyConsumed) throws InvalidCharException {
        sb = new StringBuffer(alreadyConsumed);
        curChar = this.getChar();
        try {
            block16: {
                curChar = this._queryString.charAt(this._pos);
                curChar = this.consumeWhiteSpace(curChar);
                if (curChar != '\'') {
                    throw new InvalidCharException("The timestamp keyword must be followed by a single quote.  Position: " + this._pos);
                }
                sb.append(" '");
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
                curChar = this.consumeWhiteSpace(curChar);
                if (this.isDigit(curChar)) ** GOTO lbl19
                throw new InvalidCharException("Digit expected in timestamp literal.  Position: " + this._pos);
lbl-1000:
                // 1 sources

                {
                    sb.append(curChar);
                    ++this._pos;
                    curChar = this._queryString.charAt(this._pos);
lbl19:
                    // 2 sources

                    ** while (this.isDigit((char)curChar))
                }
lbl20:
                // 1 sources

                if ((curChar = this.consumeWhiteSpace(curChar)) != '-') {
                    throw new InvalidCharException("- expected.  Fields in date part of timestamp literal must be separated by a dash.  Position: " + this._pos);
                }
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
                curChar = this.consumeWhiteSpace(curChar);
                if (this.isDigit(curChar)) ** GOTO lbl33
                throw new InvalidCharException("Digit expected in timestamp literal.  Position: " + this._pos);
lbl-1000:
                // 1 sources

                {
                    sb.append(curChar);
                    ++this._pos;
                    curChar = this._queryString.charAt(this._pos);
lbl33:
                    // 2 sources

                    ** while (this.isDigit((char)curChar))
                }
lbl34:
                // 1 sources

                if ((curChar = this.consumeWhiteSpace(curChar)) != '-') {
                    throw new InvalidCharException("- expected.  Fields in date part of timestamp literal must be separated by a dash.  Position: " + this._pos);
                }
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
                curChar = this.consumeWhiteSpace(curChar);
                if (this.isDigit(curChar)) ** GOTO lbl47
                throw new InvalidCharException("Digit expected in timestamp literal.  Position: " + this._pos);
lbl-1000:
                // 1 sources

                {
                    sb.append(curChar);
                    ++this._pos;
                    curChar = this._queryString.charAt(this._pos);
lbl47:
                    // 2 sources

                    ** while (this.isDigit((char)curChar))
                }
lbl48:
                // 1 sources

                if (!this.isWhiteSpace(curChar)) {
                    throw new InvalidCharException("White space expected in timestamp literal.  Position: " + this._pos);
                }
                curChar = this.consumeWhiteSpace(curChar);
                sb.append(' ');
                if (this.isDigit(curChar)) ** GOTO lbl59
                throw new InvalidCharException("Digit expected in timestamp literal.  Position: " + this._pos);
lbl-1000:
                // 1 sources

                {
                    sb.append(curChar);
                    ++this._pos;
                    curChar = this._queryString.charAt(this._pos);
lbl59:
                    // 2 sources

                    ** while (this.isDigit((char)curChar))
                }
lbl60:
                // 1 sources

                if ((curChar = this.consumeWhiteSpace(curChar)) != ':') {
                    throw new InvalidCharException(": expected.  Fields in time part of timestamp literal must be separated by a colon.  Position: " + this._pos);
                }
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
                curChar = this.consumeWhiteSpace(curChar);
                if (this.isDigit(curChar)) ** GOTO lbl73
                throw new InvalidCharException("Digit expected in timestamp literal.  Position: " + this._pos);
lbl-1000:
                // 1 sources

                {
                    sb.append(curChar);
                    ++this._pos;
                    curChar = this._queryString.charAt(this._pos);
lbl73:
                    // 2 sources

                    ** while (this.isDigit((char)curChar))
                }
lbl74:
                // 1 sources

                if ((curChar = this.consumeWhiteSpace(curChar)) != ':') {
                    throw new InvalidCharException(": expected.  Fields in time part of timestamp literal must be separated by a colon.  Position: " + this._pos);
                }
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
                curChar = this.consumeWhiteSpace(curChar);
                if (this.isDigit(curChar)) ** GOTO lbl87
                throw new InvalidCharException("Digit expected in timestamp literal.  Position: " + this._pos);
lbl-1000:
                // 1 sources

                {
                    sb.append(curChar);
                    ++this._pos;
                    curChar = this._queryString.charAt(this._pos);
lbl87:
                    // 2 sources

                    ** while (this.isDigit((char)curChar))
                }
lbl88:
                // 1 sources

                if (curChar != '.') break block16;
                sb.append(curChar);
                ++this._pos;
                curChar = this._queryString.charAt(this._pos);
                if (this.isDigit(curChar)) ** GOTO lbl99
                throw new InvalidCharException("Digit expected in timestamp literal.  Position: " + this._pos);
lbl-1000:
                // 1 sources

                {
                    sb.append(curChar);
                    ++this._pos;
                    curChar = this._queryString.charAt(this._pos);
lbl99:
                    // 2 sources

                    ** while (this.isDigit((char)curChar))
                }
            }
            if ((curChar = this.consumeWhiteSpace(curChar)) != '\'') {
                throw new InvalidCharException("' expected.  Timestamp literal must be enclosed by a single quotes.  Position: " + this._pos);
            }
            sb.append(curChar);
            ++this._pos;
            return new Token(39, sb.toString());
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidCharException("End of query encountered in the middle of time literal.");
        }
    }

    private char consumeWhiteSpace(char curChar) {
        while (this.isWhiteSpace(curChar)) {
            ++this._pos;
            curChar = this._queryString.charAt(this._pos);
        }
        return curChar;
    }
}

