/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.hashstore.hashstoreconverter;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.hashstore.ObjectMetadata;
import org.dataone.hashstore.exceptions.NonMatchingChecksumException;
import org.dataone.hashstore.filehashstore.FileHashStoreUtility;
import org.dataone.hashstore.hashstoreconverter.FileHashStoreLinks;

public class HashStoreConverter {
    private static final Log logHashStoreConverter = LogFactory.getLog(HashStoreConverter.class);
    private final FileHashStoreLinks fileHashStoreLinks;

    public HashStoreConverter(Properties hashstoreProperties) throws IOException, NoSuchAlgorithmException {
        try {
            this.fileHashStoreLinks = new FileHashStoreLinks(hashstoreProperties);
            logHashStoreConverter.info((Object)"HashStoreConverter initialized");
        }
        catch (IOException ioe) {
            String errMsg = "Unexpected IOException encountered: " + ioe.getMessage();
            logHashStoreConverter.error((Object)errMsg);
            throw ioe;
        }
        catch (NoSuchAlgorithmException nsae) {
            String errMsg = "A supplied algorithm is not supported: " + nsae.getMessage();
            logHashStoreConverter.error((Object)errMsg);
            throw nsae;
        }
    }

    public ObjectMetadata convert(Path filePath, String pid, InputStream sysmetaStream, String checksum, String checksumAlgorithm) throws IOException, NoSuchAlgorithmException, InterruptedException, NonMatchingChecksumException {
        logHashStoreConverter.info((Object)("Begin converting data object and sysmeta for pid: " + pid));
        FileHashStoreUtility.ensureNotNull(sysmetaStream, "sysmetaStream");
        FileHashStoreUtility.ensureNotNull(pid, "pid");
        FileHashStoreUtility.checkForNotEmptyAndValidString(pid, "pid");
        ObjectMetadata objInfo = null;
        if (filePath != null) {
            FileHashStoreUtility.ensureNotNull(checksum, "checksum");
            FileHashStoreUtility.checkForNotEmptyAndValidString(checksum, "checksum");
            FileHashStoreUtility.ensureNotNull(checksumAlgorithm, "checksumAlgorithm");
            FileHashStoreUtility.checkForNotEmptyAndValidString(checksumAlgorithm, "checksumAlgorithm");
            try {
                objInfo = this.fileHashStoreLinks.storeHardLink(filePath, pid, checksum, checksumAlgorithm);
                logHashStoreConverter.info((Object)("Stored data object for pid: " + pid));
            }
            catch (IOException ioe) {
                String errMsg = "Unexpected IOException encountered: " + ioe.getMessage();
                logHashStoreConverter.error((Object)errMsg);
                throw ioe;
            }
            catch (NoSuchAlgorithmException nsae) {
                String errMsg = "A supplied algorithm is not supported: " + nsae.getMessage();
                logHashStoreConverter.error((Object)errMsg);
                throw nsae;
            }
            catch (InterruptedException ie) {
                String errMsg = "Unexpected issue with synchronizing storing data objects or metadata: " + ie.getMessage();
                logHashStoreConverter.error((Object)errMsg);
                throw ie;
            }
        } else {
            String warnMsg = "Supplied filePath is null, not storing data object.";
            logHashStoreConverter.warn((Object)warnMsg);
        }
        try (InputStream inputStream = sysmetaStream;){
            this.fileHashStoreLinks.storeMetadata(sysmetaStream, pid);
        }
        return objInfo;
    }
}

