/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.hashstore;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.hashstore.HashStore;
import org.dataone.hashstore.exceptions.HashStoreFactoryException;

public class HashStoreFactory {
    private static final Log logHashStore = LogFactory.getLog(HashStoreFactory.class);

    public static HashStore getHashStore(String classPackage, Properties storeProperties) throws HashStoreFactoryException, IOException {
        HashStore hashstore;
        if (classPackage == null || classPackage.trim().isEmpty()) {
            String errMsg = "HashStoreFactory - classPackage cannot be null or empty.";
            logHashStore.error((Object)errMsg);
            throw new HashStoreFactoryException(errMsg);
        }
        if (storeProperties == null) {
            String errMsg = "HashStoreFactory - storeProperties cannot be null.";
            logHashStore.error((Object)errMsg);
            throw new HashStoreFactoryException(errMsg);
        }
        logHashStore.debug((Object)("Creating new 'HashStore' from package: " + classPackage));
        try {
            Class<?> hashStoreClass = Class.forName(classPackage);
            Constructor<?> constructor = hashStoreClass.getConstructor(Properties.class);
            hashstore = (HashStore)constructor.newInstance(storeProperties);
        }
        catch (ClassNotFoundException cnfe) {
            String errMsg = "HashStoreFactory - Unable to find 'FileHashStore' classPackage: " + classPackage + " - " + cnfe.getCause();
            logHashStore.error((Object)errMsg);
            throw new HashStoreFactoryException(errMsg);
        }
        catch (NoSuchMethodException nsme) {
            String errMsg = "HashStoreFactory - Constructor not found for 'FileHashStore': " + classPackage + " - " + nsme.getCause();
            logHashStore.error((Object)errMsg);
            throw new HashStoreFactoryException(errMsg);
        }
        catch (IllegalAccessException iae) {
            String errMsg = "HashStoreFactory - Executing method does not have access to the definition of the specified class , field, method or constructor. " + iae.getCause();
            logHashStore.error((Object)errMsg);
            throw new HashStoreFactoryException(errMsg);
        }
        catch (InstantiationException ie) {
            String errMsg = "HashStoreFactory - Error instantiating 'FileHashStore'(likely related to `.newInstance()`): " + ie.getCause();
            logHashStore.error((Object)errMsg);
            throw new HashStoreFactoryException(errMsg);
        }
        catch (InvocationTargetException ite) {
            String errMsg = "HashStoreFactory - Error creating 'FileHashStore' instance: " + ite.getCause();
            logHashStore.error((Object)errMsg);
            throw new HashStoreFactoryException(errMsg);
        }
        return hashstore;
    }
}

