/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Node_Variable;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.impl.LiteralLabelFactory;
import com.hp.hpl.jena.rdf.model.AnonId;

public class NodeFactory {
    public static RDFDatatype getType(String s) {
        return TypeMapper.getInstance().getSafeTypeByName(s);
    }

    public static Node createAnon() {
        return NodeFactory.createAnon(AnonId.create());
    }

    public static Node createAnon(AnonId id) {
        return Node.create(Node.makeAnon, id);
    }

    public static Node createLiteral(LiteralLabel lit) {
        return Node.create(Node.makeLiteral, lit);
    }

    public static Node createURI(String uri) {
        return Node.create(Node.makeURI, uri);
    }

    public static Node createVariable(String name) {
        return Node.create(Node.makeVariable, Node_Variable.variable(name));
    }

    public static Node createLiteral(String value) {
        return NodeFactory.createLiteral(value, "", false);
    }

    public static Node createLiteral(String lex, String lang, boolean isXml) {
        if (lex == null) {
            throw new NullPointerException("null lexical form for literal");
        }
        return NodeFactory.createLiteral(LiteralLabelFactory.create(lex, lang, isXml));
    }

    public static Node createLiteral(String lex, String lang) {
        if (lex == null) {
            throw new NullPointerException("null lexical form for literal");
        }
        return NodeFactory.createLiteral(LiteralLabelFactory.create(lex, lang));
    }

    public static Node createLiteral(String lex, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        return NodeFactory.createLiteral(LiteralLabelFactory.createLiteralLabel(lex, lang, dtype));
    }

    public static Node createLiteral(String lex, RDFDatatype dtype) throws DatatypeFormatException {
        return NodeFactory.createLiteral(LiteralLabelFactory.create(lex, dtype));
    }

    public static Node createUncachedLiteral(Object value, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        return new Node_Literal(LiteralLabelFactory.create(value, lang, dtype));
    }

    public static Node createUncachedLiteral(Object value, RDFDatatype dtype) throws DatatypeFormatException {
        return new Node_Literal(LiteralLabelFactory.create(value, "", dtype));
    }
}

