/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.catalog;

import ORG.oclc.oai.server.catalog.AbstractCatalog;
import ORG.oclc.oai.server.catalog.RecordFactory;
import ORG.oclc.oai.server.verb.BadResumptionTokenException;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.oai.server.verb.IdDoesNotExistException;
import ORG.oclc.oai.server.verb.NoItemsMatchException;
import ORG.oclc.oai.server.verb.NoMetadataFormatsException;
import ORG.oclc.oai.server.verb.NoSetHierarchyException;
import ORG.oclc.oai.server.verb.OAIInternalServerError;
import ORG.oclc.oai.util.OAIUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class NewJDBCOAICatalog
extends AbstractCatalog {
    private Connection persistentConnection = null;
    private static final boolean debug = false;
    private String identifierQuery = null;
    private String rangeQuery = null;
    private String rangeSetQuery = null;
    private String setQuery = null;
    private String setSpecQuery = null;
    private String aboutQuery = null;
    private String aboutValueLabel = null;
    private String setSpecItemLabel = null;
    private String setSpecListLabel = null;
    private String setNameLabel = null;
    private String setDescriptionLabel = null;
    private int maxListSize;
    private String dateFormat = null;
    ArrayList sets = new ArrayList();
    private HashMap resumptionResults = new HashMap();
    private String jdbcURL = null;
    private String jdbcLogin = null;
    private String jdbcPasswd = null;

    public NewJDBCOAICatalog(Properties properties) {
        this.dateFormat = properties.getProperty("JDBCOAICatalog.dateFormat");
        String maxListSize = properties.getProperty("JDBCOAICatalog.maxListSize");
        if (maxListSize == null) {
            throw new IllegalArgumentException("JDBCOAICatalog.maxListSize is missing from the properties file");
        }
        this.maxListSize = Integer.parseInt(maxListSize);
        String jdbcDriverName = properties.getProperty("JDBCOAICatalog.jdbcDriverName");
        if (jdbcDriverName == null) {
            throw new IllegalArgumentException("JDBCOAICatalog.jdbcDriverName is missing from the properties file");
        }
        this.jdbcURL = properties.getProperty("JDBCOAICatalog.jdbcURL");
        if (this.jdbcURL == null) {
            throw new IllegalArgumentException("JDBCOAICatalog.jdbcURL is missing from the properties file");
        }
        this.jdbcLogin = properties.getProperty("JDBCOAICatalog.jdbcLogin");
        if (this.jdbcLogin == null) {
            throw new IllegalArgumentException("JDBCOAICatalog.jdbcLogin is missing from the properties file");
        }
        this.jdbcPasswd = properties.getProperty("JDBCOAICatalog.jdbcPasswd");
        if (this.jdbcPasswd == null) {
            throw new IllegalArgumentException("JDBCOAICatalog.jdbcPasswd is missing from the properties file");
        }
        this.rangeQuery = properties.getProperty("JDBCOAICatalog.rangeQuery");
        if (this.rangeQuery == null) {
            throw new IllegalArgumentException("JDBCOAICatalog.rangeQuery is missing from the properties file");
        }
        this.rangeSetQuery = properties.getProperty("JDBCOAICatalog.rangeSetQuery");
        if (this.rangeSetQuery == null) {
            throw new IllegalArgumentException("JDBCOAICatalog.rangeSetQuery is missing from the properties file");
        }
        this.identifierQuery = properties.getProperty("JDBCOAICatalog.identifierQuery");
        if (this.identifierQuery == null) {
            throw new IllegalArgumentException("JDBCOAICatalog.identifierQuery is missing from the properties file");
        }
        this.aboutQuery = properties.getProperty("JDBCOAICatalog.aboutQuery");
        if (this.aboutQuery != null) {
            this.aboutValueLabel = properties.getProperty("JDBCOAICatalog.aboutValueLabel");
            if (this.aboutValueLabel == null) {
                throw new IllegalArgumentException("JDBCOAICatalog.aboutValueLabel is missing from the properties file");
            }
        }
        this.setSpecQuery = properties.getProperty("JDBCOAICatalog.setSpecQuery");
        this.setSpecItemLabel = properties.getProperty("JDBCOAICatalog.setSpecItemLabel");
        if (this.setSpecItemLabel == null) {
            throw new IllegalArgumentException("JDBCOAICatalog.setSpecItemLabel is missing from the properties file");
        }
        this.setSpecListLabel = properties.getProperty("JDBCOAICatalog.setSpecListLabel");
        if (this.setSpecListLabel == null) {
            throw new IllegalArgumentException("JDBCOAICatalog.setSpecListLabel is missing from the properties file");
        }
        this.setNameLabel = properties.getProperty("JDBCOAICatalog.setNameLabel");
        if (this.setNameLabel == null) {
            throw new IllegalArgumentException("JDBCOAICatalog.setNameLabel is missing from the properties file");
        }
        this.setDescriptionLabel = properties.getProperty("JDBCOAICatalog.setDescriptionLabel");
        this.setQuery = properties.getProperty("JDBCOAICatalog.setQuery");
        if (this.setQuery == null) {
            String propertyPrefix = "Sets.";
            Enumeration<?> propNames = properties.propertyNames();
            while (propNames.hasMoreElements()) {
                String propertyName = (String)propNames.nextElement();
                if (!propertyName.startsWith(propertyPrefix)) continue;
                this.sets.add(properties.get(propertyName));
            }
        }
        try {
            Class.forName(jdbcDriverName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("JDBCOAICatalog.jdbcDriverName is invalid: " + jdbcDriverName);
        }
    }

    public Vector getSchemaLocations(String oaiIdentifier) throws OAIInternalServerError, IdDoesNotExistException, NoMetadataFormatsException {
        StatementResultSet stmtRs = null;
        try {
            stmtRs = new StatementResultSet(this.populateIdentifierQuery(oaiIdentifier));
            if (!stmtRs.next()) {
                throw new IdDoesNotExistException(oaiIdentifier);
            }
            HashMap nativeItem = stmtRs.getColumnValues();
            Vector vector = this.getRecordFactory().getSchemaLocations(nativeItem);
            return vector;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        finally {
            try {
                if (stmtRs != null) {
                    stmtRs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new OAIInternalServerError(e.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String populateRangeQuery(String from, String until, String set) throws OAIInternalServerError {
        StringBuffer sb = new StringBuffer();
        StringTokenizer tokenizer = set == null || set.length() == 0 ? new StringTokenizer(this.rangeQuery, "\\") : new StringTokenizer(this.rangeSetQuery, "\\");
        if (!tokenizer.hasMoreTokens()) {
            throw new OAIInternalServerError("Invalid query");
        }
        sb.append(tokenizer.nextToken());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            switch (token.charAt(0)) {
                case 'f': {
                    sb.append(this.formatFromDate(from));
                    break;
                }
                case 'u': {
                    sb.append(this.formatUntilDate(until));
                    break;
                }
                case 's': {
                    sb.append(set);
                    break;
                }
                default: {
                    sb.append("\\");
                    sb.append(token.charAt(0));
                }
            }
            sb.append(token.substring(1));
        }
        return sb.toString();
    }

    protected String formatFromDate(String date) {
        return this.formatDate(date);
    }

    protected String formatUntilDate(String date) {
        return this.formatDate(date);
    }

    protected String formatDate(String date) {
        if ("UTC".equals(this.dateFormat)) {
            return date;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(date.substring(5, 7));
        sb.append("/");
        sb.append(date.substring(8));
        sb.append("/");
        sb.append(date.substring(0, 4));
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String populateIdentifierQuery(String oaiIdentifier) throws OAIInternalServerError {
        StringTokenizer tokenizer = new StringTokenizer(this.identifierQuery, "\\");
        StringBuffer sb = new StringBuffer();
        if (!tokenizer.hasMoreTokens()) {
            throw new OAIInternalServerError("Invalid identifierQuery");
        }
        sb.append(tokenizer.nextToken());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            switch (token.charAt(0)) {
                case 'i': {
                    sb.append(this.getRecordFactory().fromOAIIdentifier(oaiIdentifier));
                    break;
                }
                case 'o': {
                    sb.append(oaiIdentifier);
                    break;
                }
                default: {
                    sb.append("\\");
                    sb.append(token.charAt(0));
                }
            }
            sb.append(token.substring(1));
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String populateSetSpecQuery(String oaiIdentifier) throws OAIInternalServerError {
        StringTokenizer tokenizer = new StringTokenizer(this.setSpecQuery, "\\");
        StringBuffer sb = new StringBuffer();
        if (!tokenizer.hasMoreTokens()) {
            throw new OAIInternalServerError("Invalid identifierQuery");
        }
        sb.append(tokenizer.nextToken());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            switch (token.charAt(0)) {
                case 'i': {
                    sb.append(this.getRecordFactory().fromOAIIdentifier(oaiIdentifier));
                    break;
                }
                case 'o': {
                    sb.append(oaiIdentifier);
                    break;
                }
                default: {
                    sb.append("\\");
                    sb.append(token.charAt(0));
                }
            }
            sb.append(token.substring(1));
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String populateAboutQuery(String oaiIdentifier) throws OAIInternalServerError {
        StringTokenizer tokenizer = new StringTokenizer(this.aboutQuery, "\\");
        StringBuffer sb = new StringBuffer();
        if (!tokenizer.hasMoreTokens()) {
            throw new OAIInternalServerError("Invalid identifierQuery");
        }
        sb.append(tokenizer.nextToken());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            switch (token.charAt(0)) {
                case 'i': {
                    sb.append(this.getRecordFactory().fromOAIIdentifier(oaiIdentifier));
                    break;
                }
                case 'o': {
                    sb.append(oaiIdentifier);
                    break;
                }
                default: {
                    sb.append("\\");
                    sb.append(token.charAt(0));
                }
            }
            sb.append(token.substring(1));
        }
        return sb.toString();
    }

    public Map listIdentifiers(String from, String until, String set, String metadataPrefix) throws NoItemsMatchException, OAIInternalServerError {
        this.purge();
        HashMap<String, Object> listIdentifiersMap = new HashMap<String, Object>();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        StatementResultSet stmtRs = null;
        try {
            stmtRs = new StatementResultSet(this.populateRangeQuery(from, until, set));
            stmtRs.last();
            int numRows = stmtRs.getRow();
            if (numRows == 0) {
                throw new NoItemsMatchException();
            }
            stmtRs.beforeFirst();
            int count = 0;
            while (count < this.maxListSize && stmtRs.next()) {
                HashMap nativeItem = stmtRs.getColumnValues();
                Iterator setSpecs = this.getSetSpecs(nativeItem);
                String[] header = this.getRecordFactory().createHeader(nativeItem, setSpecs);
                headers.add(header[0]);
                identifiers.add(header[1]);
                ++count;
            }
            if (count < numRows) {
                String resumptionId = NewJDBCOAICatalog.getResumptionId();
                this.resumptionResults.put(resumptionId, stmtRs);
                StringBuffer resumptionTokenSb = new StringBuffer();
                resumptionTokenSb.append(resumptionId);
                resumptionTokenSb.append("!");
                resumptionTokenSb.append(Integer.toString(count));
                resumptionTokenSb.append("!");
                resumptionTokenSb.append(Integer.toString(numRows));
                resumptionTokenSb.append("!");
                resumptionTokenSb.append(metadataPrefix);
                listIdentifiersMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, 0));
            } else {
                stmtRs.close();
                stmtRs = null;
            }
        }
        catch (SQLException e) {
            if (stmtRs != null) {
                try {
                    stmtRs.close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        listIdentifiersMap.put("headers", headers.iterator());
        listIdentifiersMap.put("identifiers", identifiers.iterator());
        return listIdentifiersMap;
    }

    public Map listIdentifiers(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        String metadataPrefix;
        int numRows;
        int oldCount;
        String resumptionId;
        this.purge();
        HashMap<String, Object> listIdentifiersMap = new HashMap<String, Object>();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, "!");
        StatementResultSet stmtRs = null;
        try {
            resumptionId = tokenizer.nextToken();
            oldCount = Integer.parseInt(tokenizer.nextToken());
            numRows = Integer.parseInt(tokenizer.nextToken());
            metadataPrefix = tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new BadResumptionTokenException();
        }
        try {
            stmtRs = (StatementResultSet)this.resumptionResults.get(resumptionId);
            if (stmtRs == null) {
                throw new BadResumptionTokenException();
            }
            if (stmtRs.getRow() != oldCount) {
                stmtRs.absolute(oldCount);
            }
            int count = 0;
            while (count < this.maxListSize && stmtRs.next()) {
                HashMap nativeItem = stmtRs.getColumnValues();
                Iterator setSpecs = this.getSetSpecs(nativeItem);
                String[] header = this.getRecordFactory().createHeader(nativeItem, setSpecs);
                headers.add(header[0]);
                identifiers.add(header[1]);
                ++count;
            }
            if (oldCount + count < numRows) {
                StringBuffer resumptionTokenSb = new StringBuffer();
                resumptionTokenSb.append(resumptionId);
                resumptionTokenSb.append("!");
                resumptionTokenSb.append(Integer.toString(oldCount + count));
                resumptionTokenSb.append("!");
                resumptionTokenSb.append(Integer.toString(numRows));
                resumptionTokenSb.append("!");
                resumptionTokenSb.append(metadataPrefix);
                listIdentifiersMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, oldCount));
            } else {
                stmtRs.close();
                stmtRs = null;
            }
        }
        catch (SQLException e) {
            if (stmtRs != null) {
                try {
                    stmtRs.close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        listIdentifiersMap.put("headers", headers.iterator());
        listIdentifiersMap.put("identifiers", identifiers.iterator());
        return listIdentifiersMap;
    }

    public String getRecord(String oaiIdentifier, String metadataPrefix) throws OAIInternalServerError, CannotDisseminateFormatException, IdDoesNotExistException {
        StatementResultSet stmtRs = null;
        try {
            stmtRs = new StatementResultSet(this.populateIdentifierQuery(oaiIdentifier));
            if (!stmtRs.next()) {
                throw new IdDoesNotExistException(oaiIdentifier);
            }
            HashMap nativeItem = stmtRs.getColumnValues();
            String string = this.constructRecord(nativeItem, metadataPrefix);
            return string;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        finally {
            try {
                if (stmtRs != null) {
                    stmtRs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new OAIInternalServerError(e.getMessage());
            }
        }
    }

    public Map listRecords(String from, String until, String set, String metadataPrefix) throws CannotDisseminateFormatException, NoItemsMatchException, OAIInternalServerError {
        this.purge();
        HashMap<String, Object> listRecordsMap = new HashMap<String, Object>();
        ArrayList<String> records = new ArrayList<String>();
        StatementResultSet stmtRs = null;
        try {
            stmtRs = new StatementResultSet(this.populateRangeQuery(from, until, set));
            stmtRs.last();
            int numRows = stmtRs.getRow();
            if (numRows == 0) {
                throw new NoItemsMatchException();
            }
            stmtRs.beforeFirst();
            int count = 0;
            while (count < this.maxListSize && stmtRs.next()) {
                HashMap nativeItem = stmtRs.getColumnValues();
                String record = this.constructRecord(nativeItem, metadataPrefix);
                records.add(record);
                ++count;
            }
            if (count < numRows) {
                String resumptionId = NewJDBCOAICatalog.getResumptionId();
                this.resumptionResults.put(resumptionId, stmtRs);
                StringBuffer resumptionTokenSb = new StringBuffer();
                resumptionTokenSb.append(resumptionId);
                resumptionTokenSb.append("!");
                resumptionTokenSb.append(Integer.toString(count));
                resumptionTokenSb.append("!");
                resumptionTokenSb.append(Integer.toString(numRows));
                resumptionTokenSb.append("!");
                resumptionTokenSb.append(metadataPrefix);
                listRecordsMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, 0));
            } else {
                stmtRs.close();
                stmtRs = null;
            }
        }
        catch (SQLException e) {
            if (stmtRs != null) {
                try {
                    stmtRs.close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        listRecordsMap.put("records", records.iterator());
        return listRecordsMap;
    }

    public Map listRecords(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        String metadataPrefix;
        int numRows;
        int oldCount;
        String resumptionId;
        HashMap<String, Object> listRecordsMap = new HashMap<String, Object>();
        ArrayList<String> records = new ArrayList<String>();
        this.purge();
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, "!");
        StatementResultSet stmtRs = null;
        try {
            resumptionId = tokenizer.nextToken();
            oldCount = Integer.parseInt(tokenizer.nextToken());
            numRows = Integer.parseInt(tokenizer.nextToken());
            metadataPrefix = tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new BadResumptionTokenException();
        }
        try {
            stmtRs = (StatementResultSet)this.resumptionResults.get(resumptionId);
            if (stmtRs == null) {
                throw new BadResumptionTokenException();
            }
            if (stmtRs.getRow() != oldCount) {
                stmtRs.absolute(oldCount);
            }
            int count = 0;
            while (count < this.maxListSize && stmtRs.next()) {
                try {
                    HashMap nativeItem = stmtRs.getColumnValues();
                    String record = this.constructRecord(nativeItem, metadataPrefix);
                    records.add(record);
                }
                catch (CannotDisseminateFormatException e) {
                    throw new BadResumptionTokenException();
                }
                ++count;
            }
            if (oldCount + count < numRows) {
                StringBuffer resumptionTokenSb = new StringBuffer();
                resumptionTokenSb.append(resumptionId);
                resumptionTokenSb.append("!");
                resumptionTokenSb.append(Integer.toString(oldCount + count));
                resumptionTokenSb.append("!");
                resumptionTokenSb.append(Integer.toString(numRows));
                resumptionTokenSb.append("!");
                resumptionTokenSb.append(metadataPrefix);
                listRecordsMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, oldCount));
            } else {
                stmtRs.close();
                stmtRs = null;
            }
        }
        catch (SQLException e) {
            if (stmtRs != null) {
                try {
                    stmtRs.close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        listRecordsMap.put("records", records.iterator());
        return listRecordsMap;
    }

    private String constructRecord(HashMap nativeItem, String metadataPrefix) throws CannotDisseminateFormatException, OAIInternalServerError {
        String schemaURL = null;
        Iterator setSpecs = this.getSetSpecs(nativeItem);
        Iterator abouts = this.getAbouts(nativeItem);
        if (metadataPrefix != null && (schemaURL = this.getCrosswalks().getSchemaURL(metadataPrefix)) == null) {
            throw new CannotDisseminateFormatException(metadataPrefix);
        }
        return this.getRecordFactory().create(nativeItem, schemaURL, metadataPrefix, setSpecs, abouts);
    }

    public Map listSets() throws NoSetHierarchyException, OAIInternalServerError {
        StatementResultSet stmtRs = null;
        if (this.setQuery == null) {
            if (this.sets.size() == 0) {
                throw new NoSetHierarchyException();
            }
            HashMap listSetsMap = new HashMap();
            listSetsMap.put("sets", this.sets.iterator());
            return listSetsMap;
        }
        this.purge();
        HashMap<String, Object> listSetsMap = new HashMap<String, Object>();
        ArrayList<String> sets = new ArrayList<String>();
        try {
            stmtRs = new StatementResultSet(this.setQuery);
            stmtRs.last();
            int numRows = stmtRs.getRow();
            stmtRs.beforeFirst();
            int count = 0;
            while (count < this.maxListSize && stmtRs.next()) {
                HashMap nativeItem = stmtRs.getColumnValues();
                sets.add(this.getSetXML(nativeItem));
                ++count;
            }
            if (count < numRows) {
                String resumptionId = NewJDBCOAICatalog.getResumptionId();
                this.resumptionResults.put(resumptionId, stmtRs);
                StringBuffer resumptionTokenSb = new StringBuffer();
                resumptionTokenSb.append(resumptionId);
                resumptionTokenSb.append("!");
                resumptionTokenSb.append(Integer.toString(count));
                resumptionTokenSb.append("!");
                resumptionTokenSb.append(Integer.toString(numRows));
                listSetsMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, 0));
            } else {
                stmtRs.close();
                stmtRs = null;
            }
        }
        catch (SQLException e) {
            if (stmtRs != null) {
                try {
                    stmtRs.close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        listSetsMap.put("sets", sets.iterator());
        return listSetsMap;
    }

    public Map listSets(String resumptionToken) throws OAIInternalServerError, BadResumptionTokenException {
        int numRows;
        int oldCount;
        String resumptionId;
        StatementResultSet stmtRs = null;
        if (this.setQuery == null) {
            throw new BadResumptionTokenException();
        }
        this.purge();
        HashMap<String, Object> listSetsMap = new HashMap<String, Object>();
        ArrayList<String> sets = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, "!");
        try {
            resumptionId = tokenizer.nextToken();
            oldCount = Integer.parseInt(tokenizer.nextToken());
            numRows = Integer.parseInt(tokenizer.nextToken());
        }
        catch (NoSuchElementException e) {
            throw new BadResumptionTokenException();
        }
        try {
            stmtRs = (StatementResultSet)this.resumptionResults.get(resumptionId);
            if (stmtRs == null) {
                throw new BadResumptionTokenException();
            }
            if (stmtRs.getRow() != oldCount) {
                stmtRs.absolute(oldCount);
            }
            int count = 0;
            while (count < this.maxListSize && stmtRs.next()) {
                HashMap nativeItem = stmtRs.getColumnValues();
                sets.add(this.getSetXML(nativeItem));
                ++count;
            }
            if (oldCount + count < numRows) {
                StringBuffer resumptionTokenSb = new StringBuffer();
                resumptionTokenSb.append(resumptionId);
                resumptionTokenSb.append("!");
                resumptionTokenSb.append(Integer.toString(oldCount + count));
                resumptionTokenSb.append("!");
                resumptionTokenSb.append(Integer.toString(numRows));
                listSetsMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, oldCount));
            } else {
                stmtRs.close();
                stmtRs = null;
            }
        }
        catch (SQLException e) {
            if (stmtRs != null) {
                try {
                    stmtRs.close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        listSetsMap.put("sets", sets.iterator());
        return listSetsMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Iterator getSetSpecs(HashMap nativeItem) throws OAIInternalServerError {
        Iterator iterator;
        StatementResultSet stmtRs = null;
        try {
            try {
                ArrayList<String> setSpecs = new ArrayList<String>();
                if (this.setSpecQuery != null) {
                    RecordFactory rf = this.getRecordFactory();
                    String oaiIdentifier = rf.getOAIIdentifier(nativeItem);
                    stmtRs = new StatementResultSet(this.populateSetSpecQuery(oaiIdentifier));
                    while (stmtRs.next()) {
                        HashMap setMap = stmtRs.getColumnValues();
                        setSpecs.add(setMap.get(this.setSpecItemLabel).toString());
                    }
                }
                iterator = setSpecs.iterator();
                Object var8_8 = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new OAIInternalServerError(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                stmtRs.close();
                throw throwable;
            }
            catch (SQLException e2) {
                e2.printStackTrace();
                throw new OAIInternalServerError(e2.getMessage());
            }
        }
        try {}
        catch (SQLException e2) {
            e2.printStackTrace();
            throw new OAIInternalServerError(e2.getMessage());
        }
        stmtRs.close();
        return iterator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Iterator getAbouts(HashMap nativeItem) throws OAIInternalServerError {
        Iterator iterator;
        StatementResultSet stmtRs = null;
        try {
            try {
                ArrayList abouts = new ArrayList();
                if (this.aboutQuery != null) {
                    RecordFactory rf = this.getRecordFactory();
                    String oaiIdentifier = rf.getOAIIdentifier(nativeItem);
                    stmtRs = new StatementResultSet(this.populateAboutQuery(oaiIdentifier));
                    while (stmtRs.next()) {
                        HashMap aboutMap = stmtRs.getColumnValues();
                        abouts.add(aboutMap.get(this.aboutValueLabel));
                    }
                }
                iterator = abouts.iterator();
                Object var8_8 = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new OAIInternalServerError(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                stmtRs.close();
                throw throwable;
            }
            catch (SQLException e2) {
                e2.printStackTrace();
                throw new OAIInternalServerError(e2.getMessage());
            }
        }
        try {}
        catch (SQLException e2) {
            e2.printStackTrace();
            throw new OAIInternalServerError(e2.getMessage());
        }
        stmtRs.close();
        return iterator;
    }

    public String getSetXML(HashMap setItem) throws IllegalArgumentException {
        String setSpec = this.getSetSpec(setItem);
        String setName = this.getSetName(setItem);
        String setDescription = this.getSetDescription(setItem);
        StringBuffer sb = new StringBuffer();
        sb.append("<set>");
        sb.append("<setSpec>");
        sb.append(OAIUtil.xmlEncode(setSpec));
        sb.append("</setSpec>");
        sb.append("<setName>");
        sb.append(OAIUtil.xmlEncode(setName));
        sb.append("</setName>");
        if (setDescription != null) {
            sb.append("<setDescription>");
            sb.append(OAIUtil.xmlEncode(setDescription));
            sb.append("</setDescription>");
        }
        sb.append("</set>");
        return sb.toString();
    }

    protected String getSetSpec(HashMap setItem) {
        try {
            return URLEncoder.encode((String)setItem.get(this.setSpecListLabel), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "UnsupportedEncodingException";
        }
    }

    protected String getSetName(HashMap setItem) {
        return (String)setItem.get(this.setNameLabel);
    }

    protected String getSetDescription(HashMap setItem) {
        if (this.setDescriptionLabel == null) {
            return null;
        }
        return (String)setItem.get(this.setDescriptionLabel);
    }

    private Connection getNewConnection() throws SQLException {
        return DriverManager.getConnection(this.jdbcURL, this.jdbcLogin, this.jdbcPasswd);
    }

    private Connection getConnection() throws SQLException {
        if (this.persistentConnection != null) {
            if (this.persistentConnection.isClosed()) {
                System.out.println("Persistent connection has expired.");
                this.persistentConnection = this.getNewConnection();
            }
            return this.persistentConnection;
        }
        return this.getNewConnection();
    }

    public void close() {
    }

    private void purge() {
        ArrayList<String> old = new ArrayList<String>();
        Date now = new Date();
        Iterator keySet = this.resumptionResults.keySet().iterator();
        while (keySet.hasNext()) {
            String key = (String)keySet.next();
            Date then = new Date(Long.parseLong(key) + (long)this.getMillisecondsToLive());
            if (!now.after(then)) continue;
            old.add(key);
        }
        Iterator iterator = old.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            this.resumptionResults.remove(key);
        }
    }

    private static synchronized String getResumptionId() {
        Date now = new Date();
        return Long.toString(now.getTime());
    }

    private class StatementResultSet {
        private Statement stmt = null;
        private ResultSet rs = null;

        public StatementResultSet(String query) throws SQLException {
            Connection con = NewJDBCOAICatalog.this.getConnection();
            this.stmt = con.createStatement(1004, 1007);
            this.rs = this.stmt.executeQuery(query);
        }

        public Statement getStatement() {
            return this.stmt;
        }

        public ResultSet getResultSet() {
            return this.rs;
        }

        public void close() throws SQLException {
            if (this.rs != null) {
                this.rs.close();
                this.rs = null;
            }
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
        }

        public HashMap getColumnValues() throws SQLException {
            ResultSetMetaData mdata = this.rs.getMetaData();
            int count = mdata.getColumnCount();
            HashMap<String, Object> nativeItem = new HashMap<String, Object>(count);
            int i = 1;
            while (i <= count) {
                String fieldName = mdata.getTableName(i) + "." + mdata.getColumnName(i);
                nativeItem.put(fieldName, this.rs.getObject(i));
                ++i;
            }
            return nativeItem;
        }

        public boolean next() throws SQLException {
            return this.rs.next();
        }

        public void last() throws SQLException {
            this.rs.last();
        }

        public void beforeFirst() throws SQLException {
            this.rs.beforeFirst();
        }

        public int getRow() throws SQLException {
            return this.rs.getRow();
        }

        public boolean absolute(int oldCount) throws SQLException {
            return this.rs.absolute(oldCount);
        }
    }
}

